/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay.render;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CrossOverlayRenderer
implements ILightRenderer {
    private static final ResourceLocation BLANK_TEX = new ResourceLocation("moreoverlays", "textures/blank.png");
    private static Tesselator tess = Tesselator.m_85913_();
    private static BufferBuilder renderer = tess.m_85915_();
    private static Minecraft minecraft = Minecraft.m_91087_();

    private static void drawVertex(Matrix4f matrix, double x, double y, double z, float r, float g, float b) {
        float xf = (float)x;
        float yf = (float)y;
        float zf = (float)z;
        float tx = matrix.m00() * xf + matrix.m10() * yf + matrix.m20() * zf + matrix.m30();
        float ty = matrix.m01() * xf + matrix.m11() * yf + matrix.m21() * zf + matrix.m31();
        float tz = matrix.m02() * xf + matrix.m12() * yf + matrix.m22() * zf + matrix.m32();
        renderer.m_5483_((double)tx, (double)ty, (double)tz).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    private static double computeWorldWidthFromPixels(double desiredPixelWidth, double distanceToCamera) {
        double fovDegrees;
        if (desiredPixelWidth <= 0.0) {
            return 0.0;
        }
        int screenHeight = Math.max(1, Minecraft.m_91087_().m_91268_().m_85442_());
        try {
            Object fovObj = Minecraft.m_91087_().f_91066_.m_231837_().m_231551_();
            fovDegrees = fovObj instanceof Integer ? ((Integer)fovObj).doubleValue() : (fovObj instanceof Double ? (Double)fovObj : 70.0);
        }
        catch (Throwable t) {
            fovDegrees = 70.0;
        }
        double fovRadians = Math.toRadians(fovDegrees);
        double pixelsToWorldFactor = 2.0 * Math.tan(fovRadians / 2.0) / (double)screenHeight;
        double widthWorld = desiredPixelWidth * Math.max(0.0, distanceToCamera) * pixelsToWorldFactor;
        return Math.max(widthWorld, 0.01);
    }

    private static void addThickLine(Matrix4f currentMatrix, Vector3f cameraLook, double cameraX, double cameraY, double cameraZ, double ax, double ay, double az, double bx, double by, double bz, float r, float g, float b, double desiredPixelWidth) {
        float ux;
        float uy;
        float uz;
        double mx = (ax + bx) * 0.5;
        double my = (ay + by) * 0.5;
        double mz = (az + bz) * 0.5;
        double dx = mx - cameraX;
        double dy = my - cameraY;
        double dz = mz - cameraZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double worldWidth = CrossOverlayRenderer.computeWorldWidthFromPixels(desiredPixelWidth, distance);
        float half = (float)(worldWidth * 0.5);
        float vy = (float)(by - ay);
        float vz = (float)(bz - az);
        float px = vy * cameraLook.z - vz * cameraLook.y;
        float vx = (float)(bx - ax);
        float py = vz * cameraLook.x - vx * cameraLook.z;
        float pz = vx * cameraLook.y - vy * cameraLook.x;
        float plen = (float)Math.sqrt(px * px + py * py + pz * pz);
        if (plen < 1.0E-4f && (plen = (float)Math.sqrt((px = vy * (uz = 0.0f) - vz * (uy = 1.0f)) * px + (py = vz * (ux = 0.0f) - vx * uz) * py + (pz = vx * uy - vy * ux) * pz)) < 1.0E-4f) {
            return;
        }
        float inv = 1.0f / plen;
        double a1x = ax - (double)(px *= inv * half);
        double a1y = ay - (double)(py *= inv * half);
        double a1z = az - (double)(pz *= inv * half);
        double a2x = ax + (double)px;
        double a2y = ay + (double)py;
        double a2z = az + (double)pz;
        double b1x = bx - (double)px;
        double b1y = by - (double)py;
        double b1z = bz - (double)pz;
        double b2x = bx + (double)px;
        double b2y = by + (double)py;
        double b2z = bz + (double)pz;
        renderer.m_5483_((double)((float)(a1x - cameraX)), (double)((float)(a1y - cameraY)), (double)((float)(a1z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_5483_((double)((float)(b1x - cameraX)), (double)((float)(b1y - cameraY)), (double)((float)(b1z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_5483_((double)((float)(b2x - cameraX)), (double)((float)(b2y - cameraY)), (double)((float)(b2z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_5483_((double)((float)(a1x - cameraX)), (double)((float)(a1y - cameraY)), (double)((float)(a1z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_5483_((double)((float)(b2x - cameraX)), (double)((float)(b2y - cameraY)), (double)((float)(b2z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
        renderer.m_5483_((double)((float)(a2x - cameraX)), (double)((float)(a2y - cameraY)), (double)((float)(a2z - cameraZ))).m_85950_(r, g, b, 1.0f).m_5752_();
    }

    private static void renderCross(Matrix4f currentMatrix, double cameraX, double cameraY, double cameraZ, BlockPos pos, float r, float g, float b) {
        LocalPlayer player = CrossOverlayRenderer.minecraft.f_91074_;
        if (player == null) {
            return;
        }
        BlockState blockStateBelow = player.m_9236_().m_8055_(pos);
        float y = blockStateBelow.m_204336_(BlockTags.f_144279_) ? ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + ((float)pos.m_123342_() + 0.125f) : (float)((double)(0.005f + ((float)pos.m_123342_() + 0.125f)) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0))) : ((double)pos.m_123342_() > player.m_20186_() ? 0.005f + (float)pos.m_123342_() : (float)((double)(0.005f + (float)pos.m_123342_()) + (double)0.01f * -((double)pos.m_123342_() - player.m_20186_() - 1.0)));
        int x0 = pos.m_123341_();
        int x1 = x0 + 1;
        int z0 = pos.m_123343_();
        int z1 = z0 + 1;
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x0 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x1 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x1 - cameraX, (double)y - cameraY, (double)z0 - cameraZ, r, g, b);
        CrossOverlayRenderer.drawVertex(currentMatrix, (double)x0 - cameraX, (double)y - cameraY, (double)z1 - cameraZ, r, g, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack poseStack) {
        Minecraft.m_91087_().m_91097_().m_174784_(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.depthMask((boolean)false);
        float ar = (float)((Integer)Config.render_spawnAColor.get() >> 16 & 0xFF) / 255.0f;
        float ag = (float)((Integer)Config.render_spawnAColor.get() >> 8 & 0xFF) / 255.0f;
        float ab = (float)((Integer)Config.render_spawnAColor.get() & 0xFF) / 255.0f;
        float nr = (float)((Integer)Config.render_spawnNColor.get() >> 16 & 0xFF) / 255.0f;
        float ng = (float)((Integer)Config.render_spawnNColor.get() >> 8 & 0xFF) / 255.0f;
        float nb = (float)((Integer)Config.render_spawnNColor.get() & 0xFF) / 255.0f;
        double configuredWidth = (Double)Config.render_spawnLineWidth.get();
        boolean useDebugLines = configuredWidth <= 2.0;
        RenderSystem.lineWidth((float)(useDebugLines ? (float)configuredWidth : 1.0f));
        if (useDebugLines) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        renderer.m_166779_(useDebugLines ? VertexFormat.Mode.DEBUG_LINES : VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Camera camera = CrossOverlayRenderer.minecraft.f_91063_.m_109153_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        Matrix4f currentMatrix = poseStack.m_85850_().m_252922_();
        Vector3f look = new Vector3f(0.0f, 0.0f, -1.0f);
        look.rotate((Quaternionfc)camera.m_253121_());
        try {
            for (Pair<BlockPos, Byte> entry : scanner.getLightModes()) {
                Byte mode = (Byte)entry.getValue();
                if (mode == null || mode == 0) continue;
                BlockPos bp = (BlockPos)entry.getKey();
                if (useDebugLines) {
                    if (mode == 1) {
                        CrossOverlayRenderer.renderCross(currentMatrix, cameraX, cameraY, cameraZ, bp, nr, ng, nb);
                        continue;
                    }
                    if (mode != 2) continue;
                    CrossOverlayRenderer.renderCross(currentMatrix, cameraX, cameraY, cameraZ, bp, ar, ag, ab);
                    continue;
                }
                float r = mode == 1 ? nr : ar;
                float g = mode == 1 ? ng : ag;
                float b = mode == 1 ? nb : ab;
                int x0 = bp.m_123341_();
                int x1 = x0 + 1;
                int z0 = bp.m_123343_();
                int z1 = z0 + 1;
                LocalPlayer player = CrossOverlayRenderer.minecraft.f_91074_;
                if (player == null) continue;
                BlockState blockStateBelow = player.m_9236_().m_8055_(bp);
                float y = blockStateBelow.m_204336_(BlockTags.f_144279_) ? ((double)bp.m_123342_() > player.m_20186_() ? 0.005f + ((float)bp.m_123342_() + 0.125f) : (float)((double)(0.005f + ((float)bp.m_123342_() + 0.125f)) + (double)0.01f * -((double)bp.m_123342_() - player.m_20186_() - 1.0))) : ((double)bp.m_123342_() > player.m_20186_() ? 0.005f + (float)bp.m_123342_() : (float)((double)(0.005f + (float)bp.m_123342_()) + (double)0.01f * -((double)bp.m_123342_() - player.m_20186_() - 1.0)));
                double desiredPixelWidth = 1.0 + Math.max(0.0, configuredWidth - 2.0) * 0.1;
                CrossOverlayRenderer.addThickLine(currentMatrix, look, cameraX, cameraY, cameraZ, x0, y, z0, x1, y, z1, r, g, b, desiredPixelWidth);
                CrossOverlayRenderer.addThickLine(currentMatrix, look, cameraX, cameraY, cameraZ, x1, y, z0, x0, y, z1, r, g, b, desiredPixelWidth);
            }
            tess.m_85914_();
        }
        finally {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableCull();
        }
    }
}

