/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import at.ridgo8.moreoverlays.gui.config.OptionValueEntry;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public class OptionColor
extends OptionValueEntry<Integer> {
    private final EditBox tfHex;

    public OptionColor(ConfigOptionList list, ForgeConfigSpec.IntValue valSpec, ForgeConfigSpec.ValueSpec spec) {
        super(list, valSpec, spec);
        this.showValidity = true;
        this.tfHex = new EditBox(Minecraft.m_91087_().f_91062_, 165, 2, this.getConfigOptionList().m_5759_() - 160 - 5 - 64, 16, Component.m_130674_((String)""));
        this.tfHex.m_94199_(9);
        this.overrideUnsaved((Integer)((ForgeConfigSpec.IntValue)this.value).get());
    }

    @Override
    protected void renderControls(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        super.renderControls(guiGraphics, rowTop, rowLeft, rowWidth, itemHeight, mouseX, mouseY, mouseOver, partialTick);
        int controlsLeft = rowLeft + 160 + 5;
        int controlsRight = rowLeft + rowWidth - 64;
        int swatchWidth = 20;
        int swatchPad = 4;
        int editWidth = Math.max(30, controlsRight - swatchPad - swatchWidth - controlsLeft);
        this.tfHex.m_252865_(controlsLeft);
        this.tfHex.m_253211_(rowTop + 2);
        this.tfHex.m_93674_(editWidth);
        this.tfHex.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        int swatchX1 = controlsRight - swatchWidth;
        int swatchY1 = rowTop + 2;
        int swatchX2 = controlsRight - 2;
        int swatchY2 = rowTop + 2 + 16;
        guiGraphics.m_280509_(swatchX1, swatchY1, swatchX2, swatchY2, -16777216);
        int rgb = this.newValue != null && this.isValid() ? (Integer)this.newValue : (Integer)((ForgeConfigSpec.IntValue)this.value).get();
        int argb = 0xFF000000 | (rgb &= 0xFFFFFF);
        guiGraphics.m_280509_(swatchX1 + 1, swatchY1 + 1, swatchX2 - 1, swatchY2 - 1, argb);
    }

    @Override
    protected void overrideUnsaved(Integer value) {
        int rgb = value == null ? 0 : value & 0xFFFFFF;
        this.tfHex.m_94144_(String.format("#%06X", rgb));
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        ArrayList<GuiEventListener> children = new ArrayList<GuiEventListener>(super.m_6702_());
        children.add((GuiEventListener)this.tfHex);
        return children;
    }

    public void m_7522_(GuiEventListener focused) {
        super.m_7522_(focused);
        this.tfHex.m_93692_(focused == this.tfHex);
    }

    public List<? extends NarratableEntry> m_142437_() {
        return ImmutableList.of((Object)new NarratableEntry(){

            public NarratableEntry.NarrationPriority m_142684_() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void m_142291_(NarrationElementOutput output) {
                output.m_169143_(NarratedElementType.TITLE, "");
            }
        });
    }

    public boolean m_7920_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.m_7920_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        String raw = this.tfHex.m_94155_().trim();
        try {
            Integer parsed = OptionColor.parseColor(raw);
            this.updateValue(parsed);
        }
        catch (NumberFormatException ex) {
            this.updateValue(null);
        }
        return flag;
    }

    private static Integer parseColor(String s) throws NumberFormatException {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (t.isEmpty()) {
            return null;
        }
        if (t.startsWith("#")) {
            t = t.substring(1);
        }
        if (t.startsWith("0x") || t.startsWith("0X")) {
            t = t.substring(2);
        }
        if ((t = t.replace("_", "").replace(" ", "")).matches("[0-9A-Fa-f]{1,6}")) {
            int rgb = Integer.parseInt(t, 16) & 0xFFFFFF;
            return rgb;
        }
        if (t.matches("\\d+")) {
            int dec = Integer.parseInt(t);
            if (dec < 0 || dec > 0xFFFFFF) {
                throw new NumberFormatException("decimal out of range");
            }
            return dec;
        }
        throw new NumberFormatException("invalid color format");
    }
}

