/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.registry;

import com.klikli_dev.theurgy.content.item.AlchemicalSaltItem;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.LevelUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SaltRegistry {
    public static final DeferredRegister<Item> SALTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"theurgy");
    public static final RegistryObject<AlchemicalSaltItem> STRATA = SaltRegistry.register("strata");
    public static final RegistryObject<AlchemicalSaltItem> MINERAL = SaltRegistry.register("mineral");
    public static final RegistryObject<AlchemicalSaltItem> CROPS = SaltRegistry.register("crops");

    public static <T extends Item> RegistryObject<AlchemicalSaltItem> register(String name) {
        return SaltRegistry.register(name, () -> new AlchemicalSaltItem(new Item.Properties()));
    }

    public static <T extends Item> RegistryObject<T> register(String name, Supplier<T> sup) {
        return SALTS.register("alchemical_salt_" + name, sup);
    }

    public static void onBuildCreativeModTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == CreativeModeTabRegistry.THEURGY.get()) {
            Level level = LevelUtil.getLevelWithoutContext();
            if (level == null) {
                return;
            }
            RecipeManager recipeManager = level.m_7465_();
            List calcinationRecipes = recipeManager.m_44013_((RecipeType)RecipeTypeRegistry.CALCINATION.get());
            SALTS.getEntries().stream().map(RegistryObject::get).forEach(sulfur -> calcinationRecipes.stream().filter(recipe -> recipe.m_8043_(level.m_9598_()) != null && recipe.m_8043_(level.m_9598_()).m_41720_() == sulfur).forEach(recipe -> event.m_246342_(recipe.m_8043_(level.m_9598_()).m_255036_(1))));
        }
    }
}

