/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.network.messages;

import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.apparatus.caloricfluxemitter.CaloricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.network.Message;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageCaloricFluxEmitterSelection
implements Message {
    private List<CaloricFluxEmitterSelectedPoint> selectedPoints;
    private BlockPos blockPos;

    public MessageCaloricFluxEmitterSelection(BlockPos blockPos, List<CaloricFluxEmitterSelectedPoint> selectedPoints) {
        this.blockPos = blockPos;
        this.selectedPoints = selectedPoints;
    }

    public MessageCaloricFluxEmitterSelection(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockPos);
        buf.m_236828_(this.selectedPoints, (buf1, point) -> buf1.m_272073_(point.codec(), point));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.blockPos = buf.m_130135_();
        this.selectedPoints = buf.m_236845_(buf1 -> (CaloricFluxEmitterSelectedPoint)buf1.m_271872_(CaloricFluxEmitterSelectedPoint.CODEC));
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        Level level = player.m_9236_();
        if (level == null || !level.m_46749_(this.blockPos)) {
            return;
        }
        this.selectedPoints.forEach(point -> point.setLevel(level));
        BlockEntity blockEntity = level.m_7702_(this.blockPos);
        if (blockEntity instanceof CaloricFluxEmitterBlockEntity) {
            CaloricFluxEmitterBlockEntity caloricFluxEmitterBlockEntity = (CaloricFluxEmitterBlockEntity)blockEntity;
            caloricFluxEmitterBlockEntity.setSelectedPoints(this.selectedPoints);
        }
    }
}

