/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurItem;
import com.klikli_dev.theurgy.content.item.AlchemicalSulfurTier;
import com.klikli_dev.theurgy.datagen.SulfurMappings;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ReformationRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;
    private final Map<AlchemicalSulfurTier, Integer> fluxPerTier = Map.of(AlchemicalSulfurTier.ABUNDANT, 50, AlchemicalSulfurTier.COMMON, 100, AlchemicalSulfurTier.RARE, 150, AlchemicalSulfurTier.PRECIOUS, 200);
    private final Map<ResourceLocation, JsonObject> recipeCache = new HashMap<ResourceLocation, JsonObject>();
    private Set<AlchemicalSulfurItem> noAutomaticRecipesFor = Set.of();

    public ReformationRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "reformation");
    }

    private int getFlux(AlchemicalSulfurItem sulfur) {
        return this.fluxPerTier.get((Object)sulfur.tier());
    }

    private void makeXtoXRecipes(List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> sulfurToTag) {
        sulfurToTag.forEach(entry -> ((List)entry.getFirst()).stream().filter(s -> !this.noAutomaticRecipesFor.contains(s)).forEach(sulfur -> this.makeTagRecipe((Item)sulfur, (TagKey<Item>)((TagKey)entry.getSecond()), this.getFlux((AlchemicalSulfurItem)((Object)((Object)sulfur))))));
    }

    private void makeNYtoXRecipes(int n, List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> sulfurToTag) {
        sulfurToTag.forEach(entry -> ((List)entry.getFirst()).stream().filter(s -> !this.noAutomaticRecipesFor.contains(s)).forEach(sulfur -> this.makeTagRecipe((Item)sulfur, Collections.nCopies(n, (TagKey)entry.getSecond()), this.getFlux((AlchemicalSulfurItem)((Object)((Object)sulfur))))));
    }

    private void makeYtoNXRecipes(int n, List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> sulfurToTag) {
        sulfurToTag.forEach(entry -> ((List)entry.getFirst()).stream().filter(s -> !this.noAutomaticRecipesFor.contains(s)).forEach(sulfur -> this.makeTagRecipe((Item)sulfur, n, (TagKey<Item>)((TagKey)entry.getSecond()), this.getFlux((AlchemicalSulfurItem)((Object)((Object)sulfur))))));
    }

    private void makeNiterToSulfurRecipe(AlchemicalSulfurItem source, List<AlchemicalSulfurItem> targets) {
        targets.stream().filter(t -> !this.noAutomaticRecipesFor.contains(t)).forEach(target -> this.makeRecipe((Item)target, source, this.getFlux((AlchemicalSulfurItem)((Object)target))));
    }

    private void makeNiterToNiterRecipe(AlchemicalSulfurItem source, int sourceCount, AlchemicalSulfurItem target, int targetCount) {
        this.makeRecipe(target, targetCount, source, sourceCount, this.getFlux(target));
    }

    private void metals() {
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), SulfurMappings.metalsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), SulfurMappings.metalsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), SulfurMappings.metalsRare());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), SulfurMappings.metalsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> metalsFromMetals = List.of(Pair.of(SulfurMappings.metalsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_ABUNDANT), Pair.of(SulfurMappings.metalsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_COMMON), Pair.of(SulfurMappings.metalsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_RARE), Pair.of(SulfurMappings.metalsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_METALS_PRECIOUS));
        this.makeXtoXRecipes(metalsFromMetals);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 2);
    }

    private void gems() {
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), SulfurMappings.gemsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), SulfurMappings.gemsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), SulfurMappings.gemsRare());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), SulfurMappings.gemsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> gemsFromGems = List.of(Pair.of(SulfurMappings.gemsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_ABUNDANT), Pair.of(SulfurMappings.gemsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_COMMON), Pair.of(SulfurMappings.gemsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_RARE), Pair.of(SulfurMappings.gemsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_GEMS_PRECIOUS));
        this.makeXtoXRecipes(gemsFromGems);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 2, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), 4, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 4, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 4, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 1);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 4, (AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 1);
    }

    private void otherMinerals() {
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), SulfurMappings.otherMineralsAbundant());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), SulfurMappings.otherMineralsCommon());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), SulfurMappings.otherMineralsRare());
        this.makeNiterToSulfurRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), SulfurMappings.otherMineralsPrecious());
        List<Pair<List<AlchemicalSulfurItem>, TagKey<Item>>> otherMineralsFromOtherMinerals = List.of(Pair.of(SulfurMappings.otherMineralsAbundant(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_ABUNDANT), Pair.of(SulfurMappings.otherMineralsCommon(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_COMMON), Pair.of(SulfurMappings.otherMineralsRare(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_RARE), Pair.of(SulfurMappings.otherMineralsPrecious(), ItemTagRegistry.ALCHEMICAL_SULFURS_OTHER_MINERALS_PRECIOUS));
        this.makeXtoXRecipes(otherMineralsFromOtherMinerals);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_ABUNDANT.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_COMMON.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_RARE.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.METALS_PRECIOUS.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 2);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_ABUNDANT.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_ABUNDANT.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_COMMON.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_COMMON.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_RARE.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_RARE.get()), 4);
        this.makeNiterToNiterRecipe((AlchemicalSulfurItem)((Object)SulfurRegistry.GEMS_PRECIOUS.get()), 1, (AlchemicalSulfurItem)((Object)SulfurRegistry.OTHER_MINERALS_PRECIOUS.get()), 4);
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        this.noAutomaticRecipesFor = Set.of((AlchemicalSulfurItem)((Object)SulfurRegistry.ALLTHEMODIUM.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.UNOBTAINIUM.get()), (AlchemicalSulfurItem)((Object)SulfurRegistry.VIBRANIUM.get()));
        this.metals();
        this.gems();
        this.otherMinerals();
        this.recipeCache.forEach(recipeConsumer);
    }

    public void makeTagRecipe(Item result, TagKey<Item> source, int mercuryFlux) {
        this.makeTagRecipe(result, 1, source, mercuryFlux);
    }

    public void makeTagRecipe(Item result, int resultCount, TagKey<Item> source, int mercuryFlux) {
        this.makeTagRecipe(this.name(result) + "_from_" + this.name(source), result, resultCount, List.of(source), mercuryFlux, 100);
    }

    public void makeTagRecipe(Item result, List<TagKey<Item>> sources, int mercuryFlux) {
        this.makeTagRecipe(result, 1, sources, mercuryFlux);
    }

    public void makeTagRecipe(Item result, int resultCount, List<TagKey<Item>> sources, int mercuryFlux) {
        this.makeTagRecipe(this.name(result) + "_from_" + this.name(sources), result, resultCount, sources, mercuryFlux, 100);
    }

    public void makeTagRecipe(String recipeName, Item result, int resultCount, List<TagKey<Item>> sources, int mercuryFlux, int reformationTime) {
        JsonObject recipe = this.makeRecipeJson(sources.stream().map(s -> this.makeTagIngredient(this.locFor((TagKey<Item>)s))).toList(), this.makeItemIngredient(this.locFor((ItemLike)result)), mercuryFlux, this.makeItemStackCodecResult(this.locFor((ItemLike)result), resultCount), reformationTime);
        JsonArray conditions = new JsonArray();
        for (TagKey<Item> source : sources) {
            conditions.add((JsonElement)this.makeTagNotEmptyCondition(source.f_203868_().toString()));
        }
        recipe.add("conditions", (JsonElement)conditions);
        this.recipeCache.put(this.modLoc(recipeName), recipe);
    }

    public void makeRecipe(Item result, Item source, int mercuryFlux) {
        this.makeRecipe(result, 1, source, 1, mercuryFlux);
    }

    public void makeRecipe(Item result, int resultCount, Item source, int sourceCount, int mercuryFlux) {
        this.makeRecipe(this.name(result) + "_from_" + this.name(source), result, resultCount, Collections.nCopies(sourceCount, source).stream().toList(), mercuryFlux, 100);
    }

    public void makeRecipe(String recipeName, Item result, int resultCount, List<Item> sources, int mercuryFlux, int reformationTime) {
        this.recipeCache.put(this.modLoc(recipeName), this.makeRecipeJson(sources.stream().map(s -> this.makeItemIngredient(this.locFor((ItemLike)s))).toList(), this.makeItemIngredient(this.locFor((ItemLike)result)), mercuryFlux, this.makeItemStackCodecResult(this.locFor((ItemLike)result), resultCount), reformationTime));
    }

    public JsonObject makeRecipeJson(List<JsonObject> sources, JsonObject target, int mercuryFlux, JsonObject result, int reformationTime) {
        JsonArray sourcesArray = new JsonArray();
        for (JsonObject source : sources) {
            sourcesArray.add((JsonElement)source);
        }
        JsonObject recipe = new JsonObject();
        recipe.addProperty("type", RecipeTypeRegistry.REFORMATION.getId().toString());
        recipe.add("sources", (JsonElement)sourcesArray);
        recipe.add("target", (JsonElement)target);
        recipe.addProperty("mercury_flux", (Number)mercuryFlux);
        recipe.add("result", (JsonElement)result);
        recipe.addProperty("reformation_time", (Number)reformationTime);
        return recipe;
    }

    public String m_6055_() {
        return "Reformation Recipes";
    }
}

