/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.theurgy.datagen.book.ApparatusCategory;
import com.klikli_dev.theurgy.datagen.book.GettingStartedCategoryProvider;
import com.klikli_dev.theurgy.registry.CreativeModeTabRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class TheurgyBookProvider
extends BookProvider {
    public TheurgyBookProvider(PackOutput packOutput, ModonomiconLanguageProvider lang) {
        super("the_hermetica", packOutput, "theurgy", lang, new ModonomiconLanguageProvider[0]);
    }

    protected void registerDefaultMacros() {
        this.registerDefaultMacro("$PURPLE", "ad03fc");
        this.registerDefaultMacro("$INPUT", "008080");
    }

    protected BookModel generateBook() {
        this.lang.add(this.context().bookName(), "The Hermetica");
        this.lang.add(this.context().bookTooltip(), "A treatise on the Ancient Art of Alchemy.\n\u00a7o(In-Game Guide for Theurgy)\u00a7r");
        int categorySortNum = 1;
        BookCategoryModel gettingStartedCategory = new GettingStartedCategoryProvider(this).generate().withSortNumber(categorySortNum++);
        BookCategoryModel apparatusCategory = new ApparatusCategory(this).generate().withSortNumber(categorySortNum++);
        BookModel book = BookModel.create((ResourceLocation)this.modLoc(this.context().bookId()), (String)this.context().bookName()).withTooltip(this.context().bookTooltip()).withCategories(new BookCategoryModel[]{gettingStartedCategory, apparatusCategory}).withGenerateBookItem(true).withModel(this.modLoc("the_hermetica_icon")).withCreativeTab(CreativeModeTabRegistry.THEURGY.getId()).withAutoAddReadConditions(true);
        return book;
    }
}

