/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import com.klikli_dev.theurgy.content.recipe.wrapper.RecipeWrapperWithFluid;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.util.TheurgyExtraCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;

public class FermentationRecipe
implements Recipe<RecipeWrapperWithFluid> {
    public static final int DEFAULT_TIME = 200;
    public static final Codec<FermentationRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("fluid").forGetter(r -> r.fluid), (App)Codec.INT.fieldOf("fluidAmount").forGetter(r -> r.fluidAmount), (App)TheurgyExtraCodecs.INGREDIENT.listOf().fieldOf("ingredients").forGetter(r -> r.ingredients), (App)ItemStack.f_41582_.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(r -> r.time)).apply((Applicative)instance, FermentationRecipe::new));
    protected final FluidIngredient fluid;
    protected final int fluidAmount;
    protected final NonNullList<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int time;
    private final boolean hasOnlySimpleIngredients;
    protected ResourceLocation id;

    public FermentationRecipe(FluidIngredient fluid, int fluidAmount, List<Ingredient> ingredients, ItemStack result, int time) {
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.ingredients = ingredients.stream().collect(NonNullList::m_122779_, AbstractList::add, AbstractCollection::addAll);
        this.hasOnlySimpleIngredients = ingredients.stream().allMatch(Ingredient::isSimple);
        this.result = result;
        this.time = time;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.FERMENTATION.get();
    }

    public boolean matches(RecipeWrapperWithFluid pContainer, Level pLevel) {
        boolean fluidMatches;
        FluidStack fluid = pContainer.getTank().getFluidInTank(0);
        boolean bl = fluidMatches = this.fluid.test(fluid) && fluid.getAmount() >= this.fluidAmount;
        if (!fluidMatches) {
            return false;
        }
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int containerItemsCount = 0;
        for (int j = 0; j < pContainer.m_6643_(); ++j) {
            ItemStack itemstack = pContainer.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++containerItemsCount;
            if (this.hasOnlySimpleIngredients) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        if (containerItemsCount != this.ingredients.size()) {
            return false;
        }
        return this.hasOnlySimpleIngredients ? stackedcontents.m_36475_((Recipe)this, null) : RecipeMatcher.findMatches(inputs, this.ingredients) != null;
    }

    public ItemStack assemble(RecipeWrapperWithFluid pInv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ItemRegistry.FERMENTATION_VAT.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.FERMENTATION.get();
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationRecipe> {
        public FermentationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            FermentationRecipe recipe = (FermentationRecipe)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson).getOrThrow(false, s -> {
                throw new JsonParseException(s);
            });
            recipe.id = pRecipeId;
            return recipe;
        }

        public FermentationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            FermentationRecipe recipe = (FermentationRecipe)pBuffer.m_271872_(CODEC);
            recipe.id = pRecipeId;
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FermentationRecipe pRecipe) {
            pBuffer.m_272073_(CODEC, (Object)pRecipe);
        }
    }
}

