/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.registry.BlockRegistry;
import com.klikli_dev.theurgy.registry.RecipeSerializerRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CalcinationRecipe
implements Recipe<RecipeWrapper> {
    public static final int DEFAULT_CALCINATION_TIME = 100;
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final int ingredientCount;
    protected final ItemStack result;
    protected final int calcinationTime;

    public CalcinationRecipe(ResourceLocation pId, Ingredient pIngredient, int ingredientCount, ItemStack pResult, int calcinationTime) {
        this.id = pId;
        this.ingredient = pIngredient;
        this.ingredientCount = ingredientCount;
        this.result = pResult;
        this.calcinationTime = calcinationTime;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.CALCINATION.get();
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        ItemStack stack = pContainer.m_8020_(0);
        return this.ingredient.test(stack) && stack.m_41613_() >= this.ingredientCount;
    }

    public ItemStack assemble(RecipeWrapper pInv, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BlockRegistry.CALCINATION_OVEN.get());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.CALCINATION.get();
    }

    public int getCalcinationTime() {
        return this.calcinationTime;
    }

    public static class Serializer
    implements RecipeSerializer<CalcinationRecipe> {
        public CalcinationRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            JsonArray ingredientElement = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientElement);
            int ingredientCount = GsonHelper.m_13824_((JsonObject)pJson, (String)"ingredient_count", (int)1);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"), (boolean)true, (boolean)true);
            int calcinationTime = GsonHelper.m_13824_((JsonObject)pJson, (String)"calcination_time", (int)100);
            return new CalcinationRecipe(pRecipeId, ingredient, ingredientCount, result, calcinationTime);
        }

        public CalcinationRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int ingredientCount = pBuffer.m_130242_();
            ItemStack result = pBuffer.m_130267_();
            int calcinationTime = pBuffer.m_130242_();
            return new CalcinationRecipe(pRecipeId, ingredient, ingredientCount, result, calcinationTime);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CalcinationRecipe pRecipe) {
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.ingredientCount);
            pBuffer.m_130055_(pRecipe.result);
            pBuffer.m_130130_(pRecipe.calcinationTime);
        }
    }
}

