/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.particle.coloredbubble;

import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.registry.ParticleRegistry;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class ColoredBubbleParticleOptions
implements ParticleOptions {
    public static final Codec<ColoredBubbleParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue()))).apply((Applicative)instance, ColoredBubbleParticleOptions::new));
    public static final ParticleOptions.Deserializer<ColoredBubbleParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ColoredBubbleParticleOptions>(){

        public ColoredBubbleParticleOptions fromCommand(ParticleType<ColoredBubbleParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new ColoredBubbleParticleOptions(type, ParticleColor.fromString(reader.readString()));
        }

        public ColoredBubbleParticleOptions fromNetwork(ParticleType<ColoredBubbleParticleOptions> type, FriendlyByteBuf buffer) {
            return new ColoredBubbleParticleOptions(type, ParticleColor.deserialize(buffer.m_130260_()));
        }
    };
    private final ParticleType<ColoredBubbleParticleOptions> type;
    public ParticleColor color;

    public ColoredBubbleParticleOptions(float r, float g, float b) {
        this((ParticleType<ColoredBubbleParticleOptions>)((ParticleType)ParticleRegistry.COLORED_BUBBLE_TYPE.get()), new ParticleColor(r, g, b));
    }

    public ColoredBubbleParticleOptions(ParticleType<ColoredBubbleParticleOptions> particleTypeData, ParticleColor color) {
        this.type = particleTypeData;
        this.color = color;
    }

    public ParticleType<ColoredBubbleParticleOptions> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.color.serialize());
    }

    public String m_5942_() {
        return String.valueOf(ForgeRegistries.PARTICLE_TYPES.getKey(this.type)) + " " + String.valueOf(this.color.serialize());
    }
}

