/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.itemhandler;

import com.klikli_dev.theurgy.content.behaviour.itemhandler.ItemHandlerBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DynamicOneOutputSlotItemHandlerBehaviour
implements ItemHandlerBehaviour {
    protected int getOutputSlot(IItemHandler handler) {
        return handler.getSlots() - 1;
    }

    protected int getMaxInputSlot(IItemHandler handler) {
        return handler.getSlots() - 2;
    }

    @Override
    public InteractionResult useItemHandler(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        LazyOptional blockItemHandlerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!blockItemHandlerCap.isPresent()) {
            return InteractionResult.PASS;
        }
        IItemHandler blockItemHandler = (IItemHandler)blockItemHandlerCap.orElse(null);
        int outputSlot = this.getOutputSlot(blockItemHandler);
        int maxInputSlot = this.getMaxInputSlot(blockItemHandler);
        ItemStack stackInHand = pPlayer.m_21120_(pHand);
        if (stackInHand.m_41619_()) {
            ItemStack extracted = blockItemHandler.extractItem(outputSlot, blockItemHandler.getSlotLimit(outputSlot), false);
            if (!extracted.m_41619_()) {
                pPlayer.m_150109_().m_150079_(extracted);
                return InteractionResult.SUCCESS;
            }
            for (int inputSlot = 0; inputSlot <= maxInputSlot; ++inputSlot) {
                extracted = blockItemHandler.extractItem(inputSlot, blockItemHandler.getSlotLimit(inputSlot), false);
                if (extracted.m_41619_()) continue;
                pPlayer.m_150109_().m_150079_(extracted);
                return InteractionResult.SUCCESS;
            }
        } else {
            for (int inputSlot = 0; inputSlot <= maxInputSlot; ++inputSlot) {
                ItemStack remainder = blockItemHandler.insertItem(inputSlot, stackInHand, false);
                pPlayer.m_21008_(pHand, remainder);
                if (remainder.m_41613_() == stackInHand.m_41613_()) continue;
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

