/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.interaction;

import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.HasCraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.interaction.InteractionBehaviour;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class GenericVatInteractionBehaviour<R extends Recipe<?>>
implements InteractionBehaviour {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof HasCraftingBehaviour)) {
            return InteractionResult.PASS;
        }
        HasCraftingBehaviour vat = (HasCraftingBehaviour)blockEntity;
        if (!pPlayer.m_6144_() || !pPlayer.m_21205_().m_41619_()) {
            if ((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61446_) != false) return InteractionResult.PASS;
            this.showClosedMessage(pLevel, pPlayer);
            return InteractionResult.FAIL;
        }
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        CraftingBehaviour craftingBehaviour = vat.craftingBehaviour();
        Boolean isOpen = (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61446_);
        if (!isOpen.booleanValue()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)), 2);
            craftingBehaviour.stopProcessing();
            blockEntity.m_6596_();
            return InteractionResult.SUCCESS;
        }
        Optional recipe = craftingBehaviour.getRecipe();
        if (recipe.isPresent() && craftingBehaviour.canCraft((Recipe)recipe.get())) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)), 2);
            return InteractionResult.SUCCESS;
        }
        this.showNoRecipeMessage(pLevel, pPlayer);
        return InteractionResult.FAIL;
    }

    protected abstract void showNoRecipeMessage(Level var1, Player var2);

    protected abstract void showClosedMessage(Level var1, Player var2);
}

