/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.fluidhandler;

import com.klikli_dev.theurgy.content.behaviour.fluidhandler.FluidHandlerBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class OneTankFluidHandlerBehaviour
implements FluidHandlerBehaviour {
    @Override
    public InteractionResult useFluidHandler(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int amountFilled;
        FluidStack blockSimulatedDrain;
        int amountFilled2;
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        ItemStack stackInHand = pPlayer.m_21120_(pHand);
        ItemStack fillStack = stackInHand.m_255036_(1);
        LazyOptional blockFluidHandlerCap = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER);
        LazyOptional itemFluidHandlerCap = FluidUtil.getFluidHandler((ItemStack)fillStack);
        if (!blockFluidHandlerCap.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler blockFluidHandler = (IFluidHandler)blockFluidHandlerCap.orElse(null);
        if (stackInHand.m_41619_() && pPlayer.m_6144_()) {
            blockFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResult.SUCCESS;
        }
        if (!itemFluidHandlerCap.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)itemFluidHandlerCap.orElse(null);
        FluidStack simulatedDrain = itemFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!simulatedDrain.isEmpty() && (amountFilled2 = blockFluidHandler.fill(simulatedDrain, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            itemFluidHandler.drain(amountFilled2, IFluidHandler.FluidAction.EXECUTE);
            if (this.updateFluidContainerInHand(pPlayer, pHand, stackInHand, itemFluidHandler, new FluidStack(simulatedDrain.getFluid(), amountFilled2))) {
                return InteractionResult.SUCCESS;
            }
        }
        if (!(blockSimulatedDrain = blockFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() && (amountFilled = itemFluidHandler.fill(blockSimulatedDrain, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            blockFluidHandler.drain(amountFilled, IFluidHandler.FluidAction.EXECUTE);
            if (this.updateFluidContainerInHand(pPlayer, pHand, stackInHand, itemFluidHandler, new FluidStack(blockSimulatedDrain.getFluid(), amountFilled))) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean updateFluidContainerInHand(Player pPlayer, InteractionHand pHand, ItemStack stackInHand, IFluidHandlerItem itemFluidHandler, FluidStack transferredFluid) {
        if (!transferredFluid.isEmpty()) {
            stackInHand.m_41774_(1);
            if (stackInHand.m_41619_()) {
                pPlayer.m_21008_(pHand, itemFluidHandler.getContainer());
            } else {
                pPlayer.m_21008_(pHand, stackInHand);
                pPlayer.m_150109_().m_150079_(itemFluidHandler.getContainer());
            }
            return true;
        }
        return false;
    }
}

