/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.behaviour.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.recipe.ReformationRecipe;
import com.klikli_dev.theurgy.content.recipe.wrapper.ReformationArrayRecipeWrapper;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ReformationArrayCraftingBehaviour
extends CraftingBehaviour<ReformationArrayRecipeWrapper, ReformationRecipe, RecipeManager.CachedCheck<ReformationArrayRecipeWrapper, ReformationRecipe>> {
    protected final Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier;

    public ReformationArrayCraftingBehaviour(BlockEntity blockEntity, Supplier<ReformationArrayRecipeWrapper> recipeWrapperSupplier, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier) {
        super(blockEntity, recipeWrapperSupplier, inputInventorySupplier, outputInventorySupplier, RecipeManager.m_220267_((RecipeType)((RecipeType)RecipeTypeRegistry.REFORMATION.get())));
        this.mercuryFluxStorageSupplier = mercuryFluxStorageSupplier;
    }

    @Override
    public boolean canProcess(ItemStack stack) {
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((IItemHandlerModifiable)this.inputInventorySupplier.get()).getStackInSlot(0))) {
            return true;
        }
        return this.recipeCachedCheck.m_213657_((Container)((ReformationArrayRecipeWrapper)((Object)this.recipeWrapperSupplier.get())), this.blockEntity.m_58904_()).isPresent();
    }

    @Override
    protected boolean craft(ReformationRecipe pRecipe) {
        ReformationArrayRecipeWrapper recipeWrapper = (ReformationArrayRecipeWrapper)((Object)this.recipeWrapperSupplier.get());
        ItemStack assembledStack = pRecipe.assemble(recipeWrapper, this.blockEntity.m_58904_().m_9598_());
        this.mercuryFluxStorageSupplier.get().extractEnergy(pRecipe.getMercuryFlux(), false);
        HashSet<IItemHandlerModifiable> usedInventories = new HashSet<IItemHandlerModifiable>();
        block0: for (Ingredient source : pRecipe.getSources()) {
            for (IItemHandlerModifiable sourceInventory : recipeWrapper.getSourcePedestalInvs()) {
                ItemStack sourceStack;
                if (usedInventories.contains(sourceInventory) || !source.test(sourceStack = sourceInventory.getStackInSlot(0))) continue;
                usedInventories.add(sourceInventory);
                sourceInventory.extractItem(0, 1, false);
                continue block0;
            }
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)this.outputInventorySupplier.get()), (ItemStack)assembledStack, (boolean)false);
        return true;
    }

    @Override
    protected int getIngredientCount(ReformationRecipe recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(ReformationRecipe recipe) {
        return recipe.getReformationTime();
    }

    @Override
    protected int getDefaultCraftingTime() {
        return 100;
    }

    @Override
    protected int getTotalTime() {
        return this.recipeWrapperSupplier.get() != null ? super.getTotalTime() : this.getDefaultCraftingTime();
    }
}

