/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.digestionvat;

import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.content.apparatus.digestionvat.DigestionVatBlockEntity;
import com.klikli_dev.theurgy.content.render.TheurgyModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DigestionVatRenderer
implements BlockEntityRenderer<DigestionVatBlockEntity> {
    private static final ResourceLocation BASE_OPEN_TEXTURE = Theurgy.loc("textures/entity/digestion_vat/digestion_vat_base_open.png");
    private static final ResourceLocation BASE_TEXTURE = Theurgy.loc("textures/entity/digestion_vat/digestion_vat_base.png");
    private static final ResourceLocation SIDE_TEXTURE = Theurgy.loc("textures/entity/digestion_vat/digestion_vat_side.png");
    private final ModelPart neck;
    private final ModelPart frontSide;
    private final ModelPart backSide;
    private final ModelPart leftSide;
    private final ModelPart rightSide;
    private final ModelPart top;
    private final ModelPart bottom;

    public DigestionVatRenderer(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.m_173582_(TheurgyModelLayers.DIGESTION_VAT_BASE);
        this.neck = modelpart.m_171324_("neck");
        this.top = modelpart.m_171324_("top");
        this.bottom = modelpart.m_171324_("bottom");
        ModelPart modelpart1 = pContext.m_173582_(TheurgyModelLayers.DIGESTION_VAT_SIDES);
        this.frontSide = modelpart1.m_171324_("front");
        this.backSide = modelpart1.m_171324_("back");
        this.leftSide = modelpart1.m_171324_("left");
        this.rightSide = modelpart1.m_171324_("right");
    }

    public static LayerDefinition createBaseLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubedeformation = new CubeDeformation(0.2f);
        CubeDeformation cubedeformation1 = new CubeDeformation(-0.1f);
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(4.0f, 17.0f, 4.0f, 8.0f, 3.0f, 8.0f, cubedeformation1).m_171514_(0, 5).m_171488_(5.0f, 20.0f, 5.0f, 6.0f, 1.0f, 6.0f, cubedeformation), PartPose.m_171423_((float)0.0f, (float)37.0f, (float)16.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(-14, 13).m_171481_(0.0f, 0.0f, 0.0f, 14.0f, 0.0f, 14.0f);
        partdefinition.m_171599_("top", cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("bottom", cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createSidesLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(1, 0).m_271786_(0.0f, 0.0f, 0.0f, 14.0f, 16.0f, 0.0f, EnumSet.of(Direction.NORTH));
        partdefinition.m_171599_("back", cubelistbuilder, PartPose.m_171423_((float)15.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
        partdefinition.m_171599_("left", cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)1.0f, (float)0.0f, (float)-1.5707964f, (float)((float)Math.PI)));
        partdefinition.m_171599_("right", cubelistbuilder, PartPose.m_171423_((float)15.0f, (float)16.0f, (float)15.0f, (float)0.0f, (float)1.5707964f, (float)((float)Math.PI)));
        partdefinition.m_171599_("front", cubelistbuilder, PartPose.m_171423_((float)1.0f, (float)16.0f, (float)15.0f, (float)((float)Math.PI), (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void render(DigestionVatBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        pPoseStack.m_85836_();
        Direction direction = pBlockEntity.getDirection();
        pPoseStack.m_85837_(0.5, 0.0, 0.5);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - direction.m_122435_()));
        pPoseStack.m_85837_(-0.5, 0.0, -0.5);
        ResourceLocation baseTexture = (Boolean)pBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_) != false ? BASE_OPEN_TEXTURE : BASE_TEXTURE;
        RenderType baseRenderType = RenderType.m_110446_((ResourceLocation)baseTexture);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(baseRenderType);
        this.neck.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.top.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.bottom.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.renderSide(this.frontSide, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.renderSide(this.backSide, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.renderSide(this.leftSide, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.renderSide(this.rightSide, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
    }

    private void renderSide(ModelPart pModelPart, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        RenderType renderType = RenderType.m_110446_((ResourceLocation)SIDE_TEXTURE);
        pModelPart.m_104301_(pPoseStack, pBuffer.m_6299_(renderType), pPackedLight, pPackedOverlay);
    }
}

