/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.common.mob_jar;

import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.klikli_dev.occultism.api.OccultismAPI;
import com.klikli_dev.occultism.common.entity.job.CleanerJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.mystchonky.arsocultas.common.mob_jar.SpiritMenuWrapper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class SpiritBehaviour<T extends SpiritEntity>
extends JarBehavior<T> {
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        if (world.f_46443_) {
            return;
        }
        ItemStack heldStack = player.m_21120_(handIn);
        SpiritEntity spirit = (SpiritEntity)this.entityFromJar(tile);
        if (player.m_36341_() && heldStack.m_41619_()) {
            this.openScreen(player, spirit, tile);
            return;
        }
        if (this.canAcceptItemStack(spirit, heldStack)) {
            ItemStack duplicate = heldStack.m_41777_();
            ItemStackHandler handler = (ItemStackHandler)spirit.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).m_41613_() < duplicate.m_41613_()) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                heldStack.m_41764_(remaining.m_41613_());
            }
        }
    }

    public void tick(MobJarTile tile) {
        ItemEntity itemEntity;
        List itemEntities;
        Level level = tile.m_58904_();
        if (level.f_46443_) {
            return;
        }
        SpiritEntity spirit = (SpiritEntity)this.entityFromJar(tile);
        if (!spirit.isInitialized()) {
            spirit.init();
        }
        if (level.m_46467_() % 40L == 0L && !(itemEntities = level.m_6443_(ItemEntity.class, new AABB(tile.m_58899_()).m_82400_(3.0), Entity::m_6084_)).isEmpty() && (itemEntity = (ItemEntity)itemEntities.stream().filter(item -> OccultismAPI.get().canPickupItem((Entity)spirit, item).orElse(false)).findFirst().orElse(null)) != null) {
            ItemStack duplicate = itemEntity.m_32055_().m_41777_();
            ItemStackHandler handler = (ItemStackHandler)spirit.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).m_41613_() < duplicate.m_41613_()) {
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                itemEntity.m_32055_().m_41764_(remaining.m_41613_());
            }
        }
        spirit.getJob().ifPresent(spiritJob -> {
            if (spiritJob instanceof CleanerJob) {
                List inventories = InvUtil.adjacentInventories((Level)level, (BlockPos)tile.m_58899_());
                if (inventories.isEmpty()) {
                    return;
                }
                InventoryManager manager = new InventoryManager(inventories);
                MultiInsertReference reference = manager.insertStackWithReference(spirit.m_21120_(InteractionHand.MAIN_HAND));
                if (!reference.isEmpty()) {
                    ItemStack remainder = reference.getRemainder();
                    spirit.m_21008_(InteractionHand.MAIN_HAND, remainder);
                    level.m_5594_(null, tile.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 1.0f);
                }
            }
            spiritJob.update();
            tile.updateBlock();
        });
    }

    private boolean canAcceptItemStack(SpiritEntity spirit, ItemStack stack) {
        OccultismAPI api = OccultismAPI.get();
        if (api.getItemsToPickUp((Entity)spirit).isPresent()) {
            return ((List)api.getItemsToPickUp((Entity)spirit).get()).stream().anyMatch(item -> item.test(stack));
        }
        return false;
    }

    public void getTooltip(MobJarTile tile, List<Component> tooltips) {
        super.getTooltip(tile, tooltips);
    }

    public void openScreen(Player playerEntity, SpiritEntity spirit, MobJarTile tile) {
        SpiritMenuWrapper<SpiritEntity> menuProvider;
        SpiritJob currentJob = spirit.getJob().orElse(null);
        if (currentJob instanceof MenuProvider) {
            MenuProvider jobMenuProvider = (MenuProvider)currentJob;
            menuProvider = new SpiritMenuWrapper<MenuProvider>(jobMenuProvider, spirit);
        } else {
            menuProvider = new SpiritMenuWrapper<SpiritEntity>(spirit, spirit);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerEntity), menuProvider, buf -> buf.m_130064_(tile.m_58899_()));
    }
}

