/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.data;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.data.providers.AetherBlockStateProvider;
import com.aetherteam.aether.data.providers.AetherItemModelProvider;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.legacy.lost_aether.LostContentMod;
import com.legacy.lost_aether.item.util.CustomHeadArmorItem;
import com.legacy.lost_aether.registry.LCBlocks;
import com.legacy.lost_aether.registry.LCItems;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class LCModelProv {
    protected static List<Block> getAllBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("lost_aether_content")).toList();
    }

    protected static List<Item> getAllItems(Function<Item, Boolean> condition) {
        return ForgeRegistries.ITEMS.getValues().stream().filter(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("lost_aether_content") && (Boolean)condition.apply((Item)item) != false).toList();
    }

    protected static List<Item> getAllItems() {
        return LCModelProv.getAllItems(i -> true);
    }

    public static class States
    extends AetherBlockStateProvider {
        public States(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "lost_aether_content", existingFileHelper);
        }

        protected void registerStatesAndModels() {
            Block gale = LCBlocks.gale_stone;
            Block lightGale = LCBlocks.light_gale_stone;
            this.blockTop(gale, "dungeon/");
            BlockModelBuilder lightBlock = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(lightGale), this.mcLoc("block/block"))).renderType("cutout");
            ModelBuilder.ElementBuilder mainElement = lightBlock.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
            for (Direction dir : Direction.values()) {
                mainElement.face(dir).texture(dir == Direction.UP || dir == Direction.DOWN ? "#top" : "#all").uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(dir).end();
            }
            ModelBuilder.ElementBuilder glowElement = lightBlock.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
            for (Direction dir : Direction.values()) {
                glowElement.face(dir).texture(dir == Direction.UP || dir == Direction.DOWN ? "#top_glow" : "#glow").emissivity(15, 15).uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(dir).end();
            }
            ResourceLocation lightTex = this.texture(this.name(lightGale), "dungeon/");
            this.simpleBlock(lightGale, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)lightBlock.texture("all", lightTex)).texture("glow", this.extend(lightTex, "_glow"))).texture("top", this.extend(lightTex, "_top"))).texture("top_glow", this.extend(lightTex, "_top_glow"))).texture("particle", "#all"));
            this.dungeonBlock(LCBlocks.locked_gale_stone, gale);
            this.dungeonBlock(LCBlocks.locked_light_gale_stone, lightGale);
            this.dungeonBlock(LCBlocks.trapped_gale_stone, gale);
            this.dungeonBlock(LCBlocks.trapped_light_gale_stone, lightGale);
            this.dungeonBlock(LCBlocks.treasure_doorway_gale_stone, gale);
            this.dungeonBlock(LCBlocks.treasure_doorway_light_gale_stone, lightGale);
            this.invisibleBlock(LCBlocks.boss_doorway_gale_stone, gale);
            this.invisibleBlock(LCBlocks.boss_doorway_light_gale_stone, lightGale);
            this.pillar((RotatedPillarBlock)LCBlocks.gale_pillar);
            this.translucentBlock(LCBlocks.pink_aercloud, "");
            this.translucentBlock(LCBlocks.enchanted_pink_aercloud, "");
            String dungeonDir = "dungeon/";
            this.stairsBlock((StairBlock)LCBlocks.gale_stairs, this.texture(this.name(gale), dungeonDir), this.texture(this.name(gale) + "_top", dungeonDir), this.texture(this.name(gale) + "_top", dungeonDir));
            this.slabBlock((SlabBlock)LCBlocks.gale_slab, this.texture(this.name(gale)), this.texture(this.name(gale), dungeonDir), this.texture(this.name(gale) + "_top", dungeonDir), this.texture(this.name(gale) + "_top", dungeonDir));
            this.wallBlock((WallBlock)LCBlocks.gale_wall, this.name(gale), this.texture(this.name(gale) + "_top", dungeonDir));
            Block songstoneBlock = LCBlocks.songstone;
            ResourceLocation songstoneTexture = this.texture("songstone", "dungeon/");
            BlockModelBuilder songstoneModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(songstoneBlock), this.mcLoc("block/block"))).renderType("cutout")).texture("bottom", this.texture(this.name(gale) + "_top", "dungeon/"))).texture("top", this.extend(songstoneTexture, "_top"))).texture("side", this.extend(songstoneTexture, "_side"))).texture("particle", this.extend(songstoneTexture, "_side"));
            ModelBuilder.ElementBuilder e1 = songstoneModel.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
            for (Direction dir : Direction.values()) {
                String name = dir == Direction.UP ? "top" : (dir == Direction.DOWN ? "bottom" : "side");
                e1.face(dir).texture("#" + name).uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(dir).end();
            }
            ModelBuilder.ElementBuilder e2 = songstoneModel.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN) continue;
                String name = dir == Direction.UP ? "top_glow" : "side_glow";
                e2.face(dir).texture("#" + name).emissivity(15, 15).uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(dir).end();
            }
            this.simpleBlock(songstoneBlock, (ModelFile)((BlockModelBuilder)songstoneModel.texture("side_glow", this.extend(songstoneTexture, "_side_glow"))).texture("top_glow", this.extend(songstoneTexture, "_top_glow")));
            this.saplingBlock(LCBlocks.crystal_sapling, "");
            this.saplingBlock(LCBlocks.holiday_sapling, "");
            this.pottedPlant(LCBlocks.potted_crystal_sapling, LCBlocks.crystal_sapling, "");
            this.pottedPlant(LCBlocks.potted_holiday_sapling, LCBlocks.holiday_sapling, "");
            LCModelProv.getAllBlocks().stream().filter(b -> !this.registeredBlocks.containsKey(b)).forEach(block -> System.err.println("Forgot " + block));
        }

        public void dungeonBlock(Block block, Block baseBlock) {
            ConfiguredModel dungeonBlock = new ConfiguredModel((ModelFile)this.models().withExistingParent(this.name(block), LostContentMod.locate(this.name(baseBlock))));
            this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{dungeonBlock});
        }

        public void invisibleBlock(Block block, Block baseBlock) {
            ModelBuilder visible = this.models().withExistingParent(this.name(block), LostContentMod.locate(this.name(baseBlock)));
            ModelBuilder invisible = this.models().getBuilder(this.name(block));
            this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> States.lambda$invisibleBlock$2((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
        }

        public void blockTop(Block block, String location) {
            String dir = "dungeon/";
            this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.name(block), this.texture(this.name(block), dir), this.texture(this.name(block) + "_top", dir), this.texture(this.name(block) + "_top", dir)));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$invisibleBlock$2(ModelFile visible, ModelFile invisible, BlockState state) {
            return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)DoorwayBlock.INVISIBLE) == false ? visible : invisible).build();
        }
    }

    public static class Items
    extends AetherItemModelProvider {
        public Items(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "lost_aether_content", existingFileHelper);
        }

        protected void registerModels() {
            this.itemBlock(LCBlocks.gale_stone);
            this.itemBlock(LCBlocks.light_gale_stone);
            this.itemLockedDungeonBlock(LCBlocks.locked_gale_stone, LCBlocks.gale_stone);
            this.itemLockedDungeonBlock(LCBlocks.locked_light_gale_stone, LCBlocks.light_gale_stone);
            this.itemBossDoorwayDungeonBlock(LCBlocks.boss_doorway_gale_stone, LCBlocks.gale_stone);
            this.itemBossDoorwayDungeonBlock(LCBlocks.boss_doorway_light_gale_stone, LCBlocks.light_gale_stone);
            this.itemTreasureDoorwayDungeonBlock(LCBlocks.treasure_doorway_gale_stone, LCBlocks.gale_stone);
            this.itemTreasureDoorwayDungeonBlock(LCBlocks.treasure_doorway_light_gale_stone, LCBlocks.light_gale_stone);
            this.itemTrappedDungeonBlock(LCBlocks.trapped_gale_stone, LCBlocks.gale_stone);
            this.itemTrappedDungeonBlock(LCBlocks.trapped_light_gale_stone, LCBlocks.light_gale_stone);
            this.itemBlock(LCBlocks.songstone);
            this.itemBlock(LCBlocks.gale_pillar);
            this.itemBlock(LCBlocks.gale_stairs);
            this.itemBlock(LCBlocks.gale_slab);
            this.itemBlock(LCBlocks.pink_aercloud);
            this.itemBlock(LCBlocks.enchanted_pink_aercloud);
            this.wallInventory(this.blockName(LCBlocks.gale_wall), this.texture(this.blockName(LCBlocks.gale_stone) + "_top", "dungeon/"));
            this.itemBlockFlat(LCBlocks.crystal_sapling, "");
            this.itemBlockFlat(LCBlocks.holiday_sapling, "");
            this.bootsItem(LCItems.agility_boots, "");
            this.glovesItem(LCItems.power_gloves, "");
            LCModelProv.getAllItems(i -> !(i instanceof BlockItem)).forEach(item -> {
                if (item instanceof TieredItem) {
                    this.handheldItem((Item)item, "");
                } else if (item instanceof MoaEggItem) {
                    this.moaEggItem((Item)item, "miscellaneous/");
                } else if (!(item instanceof ShieldItem) && !(item instanceof CustomHeadArmorItem) && item != LCItems.sentry_shield) {
                    this.basicItem((Item)item);
                }
            });
            this.rotatedItem((Item)LCItems.platinum_key, "");
            ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(LCItems.sentry_shield), "forge:item/default")).texture("layer0", this.itemTexture(this.itemName(LCItems.sentry_shield)))).texture("layer1", this.itemTexture(this.itemName(LCItems.sentry_shield) + "_glow"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
        }

        public ResourceLocation modLoc(String name) {
            if (name.startsWith("trims/items/gloves_trim_")) {
                return new ResourceLocation("aether", name);
            }
            return super.modLoc(name);
        }

        public void itemBossDoorwayDungeonBlock(Block block, Block baseBlock) {
            ((ItemModelBuilder)this.withExistingParent(this.blockName(block), new ResourceLocation("aether", this.blockName((Block)AetherBlocks.BOSS_DOORWAY_CARVED_STONE.get())))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"));
        }

        public void itemLockedDungeonBlock(Block block, Block baseBlock) {
            ((ItemModelBuilder)this.withExistingParent(this.blockName(block), new ResourceLocation("aether", this.blockName((Block)AetherBlocks.LOCKED_CARVED_STONE.get())))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"));
        }

        public void itemTrappedDungeonBlock(Block block, Block baseBlock) {
            ((ItemModelBuilder)this.withExistingParent(this.blockName(block), new ResourceLocation("aether", this.blockName((Block)AetherBlocks.TRAPPED_CARVED_STONE.get())))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"));
        }

        public void itemTreasureDoorwayDungeonBlock(Block block, Block baseBlock) {
            ((ItemModelBuilder)this.withExistingParent(this.blockName(block), new ResourceLocation("aether", this.blockName((Block)AetherBlocks.TREASURE_DOORWAY_CARVED_STONE.get())))).texture("face", this.texture(this.blockName(baseBlock), "dungeon/"));
        }

        public void moaEggItem(Item item, String location) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", new ResourceLocation("aether", "item/" + location + "moa_egg"))).texture("layer1", new ResourceLocation("aether", "item/" + location + "moa_egg_spot"));
        }

        protected ResourceLocation aeTexture(String name, String location) {
            return new ResourceLocation("aether", "block/" + location + name);
        }

        protected ResourceLocation itemTexture(String name) {
            return this.modLoc("item/" + name);
        }
    }
}

