/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.client;

import com.aetherteam.aether.client.renderer.AetherModelLayers;
import com.aetherteam.aether.client.renderer.entity.FlyingCowRenderer;
import com.aetherteam.aether.client.renderer.entity.MoaRenderer;
import com.aetherteam.aether.client.renderer.entity.PhygRenderer;
import com.aetherteam.aether.client.renderer.entity.ValkyrieQueenRenderer;
import com.aetherteam.aether.client.renderer.entity.ValkyrieRenderer;
import com.aetherteam.aether.client.renderer.entity.model.CrystalModel;
import com.aetherteam.aether.client.renderer.entity.model.HaloModel;
import com.aetherteam.aether.client.renderer.entity.model.QuadrupedWingsModel;
import com.legacy.lost_aether.client.LCRenderRefs;
import com.legacy.lost_aether.client.models.AerwhaleKingModel;
import com.legacy.lost_aether.client.models.AerwhaleModelOverride;
import com.legacy.lost_aether.client.models.FeatheredMoaModel;
import com.legacy.lost_aether.client.render.AerwhaleKingRenderer;
import com.legacy.lost_aether.client.render.CloudShotRenderer;
import com.legacy.lost_aether.client.render.FallingRockRenderer;
import com.legacy.lost_aether.client.render.layer.ColoredWingsBodyLayer;
import com.legacy.lost_aether.client.render.layer.ColoredWingsLayer;
import com.legacy.lost_aether.client.render.layer.MoaHeadFeatherLayer;
import com.legacy.lost_aether.client.render.layer.ValkyrieHaloLayer;
import com.legacy.lost_aether.registry.LCEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lost_aether_content", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class LCEntityRendering {
    @SubscribeEvent
    public static void initLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(LCRenderRefs.AERWHALE_KING, AerwhaleKingModel::createBodyLayer);
        event.registerLayerDefinition(LCRenderRefs.FALLING_ROCK, CrystalModel::createBodyLayer);
        event.registerLayerDefinition(LCRenderRefs.VALKYRIE_HALO, () -> HaloModel.createLayer((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        event.registerLayerDefinition(LCRenderRefs.VALKYRIE_QUEEN_HALO, () -> HaloModel.createLayer((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        event.registerLayerDefinition(LCRenderRefs.MOA_FEATHERS, FeatheredMoaModel::createBodyLayer);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void initPostLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AetherModelLayers.AERWHALE, AerwhaleModelOverride::createOverrideLayer);
    }

    @SubscribeEvent
    public static void initRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(LCEntityTypes.AERWHALE_KING, AerwhaleKingRenderer::new);
        event.registerEntityRenderer(LCEntityTypes.FALLING_ROCK, FallingRockRenderer::new);
        event.registerEntityRenderer(LCEntityTypes.CLOUD_SHOT, CloudShotRenderer::new);
    }

    @SubscribeEvent
    public static void addRenderLayers(EntityRenderersEvent.AddLayers event) {
        Minecraft mc = Minecraft.m_91087_();
        for (EntityRenderer renderer : mc.m_91290_().f_114362_.values()) {
            PhygRenderer r;
            if (renderer instanceof PhygRenderer) {
                r = (PhygRenderer)renderer;
                r.m_115326_(new ColoredWingsBodyLayer(r));
                r.m_115326_(new ColoredWingsLayer(r, new QuadrupedWingsModel(mc.m_167973_().m_171103_(AetherModelLayers.PHYG_WINGS))));
            }
            if (renderer instanceof FlyingCowRenderer) {
                r = (FlyingCowRenderer)renderer;
                r.m_115326_(new ColoredWingsBodyLayer(r));
                r.m_115326_(new ColoredWingsLayer(r, new QuadrupedWingsModel(mc.m_167973_().m_171103_(AetherModelLayers.FLYING_COW_WINGS))));
            }
            if (renderer instanceof ValkyrieRenderer) {
                r = (ValkyrieRenderer)renderer;
                r.m_115326_(new ValkyrieHaloLayer(r, new HaloModel(mc.m_167973_().m_171103_(LCRenderRefs.VALKYRIE_HALO))));
            }
            if (renderer instanceof ValkyrieQueenRenderer) {
                r = (ValkyrieQueenRenderer)renderer;
                r.m_115326_(new ValkyrieHaloLayer(r, new HaloModel(mc.m_167973_().m_171103_(LCRenderRefs.VALKYRIE_QUEEN_HALO))));
            }
            if (!(renderer instanceof MoaRenderer)) continue;
            r = (MoaRenderer)renderer;
            r.m_115326_(new MoaHeadFeatherLayer(r, new FeatheredMoaModel(mc.m_167973_().m_171103_(LCRenderRefs.MOA_FEATHERS))));
        }
    }
}

