/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether;

import com.legacy.lost_aether.client.MountRotationType;
import com.legacy.structure_gel.api.config.ConfigBuilder;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LostContentConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final World WORLD;
    public static final ForgeConfigSpec WORLD_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(World::new);
        WORLD_SPEC = (ForgeConfigSpec)specPair.getRight();
        WORLD = (World)specPair.getLeft();
    }

    public static class Common {
        public Common(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> valkyrieHalos;
        public final ForgeConfigSpec.ConfigValue<Boolean> valkyrieQueenHalos;
        public final ForgeConfigSpec.ConfigValue<Boolean> updatedAerwhaleAnimations;
        public final ForgeConfigSpec.ConfigValue<Boolean> aerwhaleKingBossMusic;
        public final ForgeConfigSpec.ConfigValue<MountRotationType> mountRotationType;
        public final ForgeConfigSpec.ConfigValue<Double> orangeMoaFovScale;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Aether: Lost Content Client Configuration");
            builder.push("Visuals");
            this.valkyrieHalos = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"valkyrie_halos", (String)"Gives Valkyries halos, as they had in Aether Legacy.\n", (boolean)false);
            this.valkyrieQueenHalos = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"valkyrie_queen_halo", (String)"Gives the Valkyrie Queen a halo, as in Aether Legacy.\n", (boolean)false);
            this.updatedAerwhaleAnimations = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"updated_aerwhale_animations", (String)"Gives the otherwise lifeless Aerwhales animation.\n This brings them more in-line with the Aerwhale King, preventing them from standing out.\n", (boolean)true);
            this.aerwhaleKingBossMusic = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"aerwhale_king_boss_music", (String)"Plays dynamic boss music during the fight with the Aerwhale King.", (boolean)true);
            StringBuilder mountString = new StringBuilder();
            mountString.append("Modifies how mountable Aether mobs feel while riding to resemble different versions of the mod. This has no effect on gameplay.\n");
            mountString.append("\n NONE: Stiff rotation, exactly matching the rider. This is what Minecraft, and Aether use normally.");
            mountString.append("\n CLASSIC: Smooth, but loose feeling. Mounts will also turn in the direction you strafe in, otherwise staying close to where you're looking. This is how mounts were in original versions of the Aether.");
            mountString.append("\n LEGACY: Snappy, but not as stiff feeling movement. Close to how NONE works, but mounts will adopt a \"drifting\" pose while strafing, moving their heads to the opposite direction of travel. This is how mounts controlled in Aether Legacy.");
            mountString.append("\n SMOOTH_LEGACY: A best of both worlds solution. This combines the drifting pose of LEGACY, and the loose feeling of CLASSIC. This is an all new type of rotation.\n");
            this.mountRotationType = ConfigBuilder.makeEnum((ForgeConfigSpec.Builder)builder, (String)"mount_rotation_type", (String)mountString.toString(), (Enum)MountRotationType.CLASSIC);
            this.orangeMoaFovScale = ConfigBuilder.makeDouble((ForgeConfigSpec.Builder)builder, (String)"orange_moa_fov_scale", (String)"How much FOV scales riding an Orange Moa as it gains speed.\n Can be set to 0 to disable.\n", (double)10.0, (double)0.0, (double)60.0);
            builder.pop();
        }
    }

    public static class World {
        public final ForgeConfigSpec.ConfigValue<Boolean> mutationWingColors;
        public final ForgeConfigSpec.ConfigValue<Boolean> mutationAnimalSounds;

        public World(ForgeConfigSpec.Builder builder) {
            builder.comment("Aether: Lost Content World Configuration");
            builder.push("Animal Tweaks");
            this.mutationWingColors = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"mutation_wing_colors", (String)"Allows Phygs and Flying Cows to spawn with Silver or Bronze wing colors.\n This is a feature that was in the scrapped Mutation update for Aether II.", (boolean)true);
            this.mutationAnimalSounds = ConfigBuilder.makeBoolean((ForgeConfigSpec.Builder)builder, (String)"mutation_animal_sounds", (String)"Gives Phygs, Sheepuff, and Flying Cows unique sounds.\n These are from the scrapped Mutation update for Aether II, although modified slightly.", (boolean)true);
            builder.pop();
        }
    }
}

