/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.config.BlockMatcher;
import tictim.paraglider.config.Cfg;

public class LocalConfig
implements Cfg {
    protected final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue ascendingWinds;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> windSources;
    @Nullable
    private BlockMatcher windSourcesParsed = null;
    private final ForgeConfigSpec.DoubleValue paraglidingSpeed;
    private final ForgeConfigSpec.IntValue paragliderDurability;
    private final ForgeConfigSpec.BooleanValue enderDragonDropsVessel;
    private final ForgeConfigSpec.BooleanValue witherDropsVessel;
    private final ForgeConfigSpec.BooleanValue raidGivesVessel;
    private final ForgeConfigSpec.IntValue spawnerSpiritOrbDrops;
    private final ForgeConfigSpec.BooleanValue spiritOrbLoots;
    private final ForgeConfigSpec.IntValue startingHearts;
    private final ForgeConfigSpec.IntValue maxHeartContainers;
    private final ForgeConfigSpec.IntValue maxStamina;
    private final ForgeConfigSpec.IntValue startingStamina;
    private final ForgeConfigSpec.IntValue maxStaminaVessels;
    private final ForgeConfigSpec.BooleanValue paraglidingConsumesStamina;
    private final ForgeConfigSpec.BooleanValue runningConsumesStamina;
    private final ForgeConfigSpec.EnumValue<Cfg.TotwCompatConfigOption> paragliderInTowersOfTheWild;

    public LocalConfig() {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        this.ascendingWinds = b.comment("Fire will float you upward.").define("ascendingWinds", true);
        this.windSources = b.comment("You can customize which block produces wind.\nWrite each blockstate to one of this format:\n  [block ID]   (Matches all state of the block)\n  [block ID]#[property1=value],[property2=value],[property3=value]   (Matches state of the block that has specified properties)\n  #[Tag ID]   (Matches all blocks with the tag)\nSame property cannot be specified multiple times. Wind sources with any invalid part will be excluded.").defineListAllowEmpty(Collections.singletonList("windSources"), () -> ImmutableList.of((Object)"fire", (Object)"soul_fire", (Object)"campfire#lit=true", (Object)"soul_campfire#lit=true"), o -> true);
        this.paraglidingSpeed = b.comment("Multiplier to horizontal movement speed while paragliding.\nValue of 0.5 means 50% of the speed, 2.0 means two times the speed and so forth.").defineInRange("paraglidingSpeed", 1.0, 0.2, 10.0);
        this.paragliderDurability = b.comment("Durability of Paragliders. Set to zero to disable durability.").defineInRange("paragliderDurability", 0, 0, Integer.MAX_VALUE);
        b.push("spiritOrbs");
        this.enderDragonDropsVessel = b.comment("If true, Ender Dragon will drop heart container(stamina vessel if heart container is disabled) upon death.").define("enderDragonDropsVessel", true);
        this.witherDropsVessel = b.comment("If true, Wither will drop heart container(stamina vessel if heart container is disabled) upon death.").define("enderDragonDropsVessel", true);
        this.raidGivesVessel = b.comment("If true, Raids will give heart container(stamina vessel if heart container is disabled) upon victory.").define("raidGivesVessel", true);
        this.spawnerSpiritOrbDrops = b.comment("Amount of Spirit Orbs dropped from spawners.").defineInRange("spawnerSpiritOrbDrops", 2, 0, 64);
        this.spiritOrbLoots = b.comment("If true, various types of chest will have chances of having Spirit Orbs inside.\nDoes not change contents of already generated chests.").define("spiritOrbLoots", true);
        b.pop();
        b.push("vessels");
        this.startingHearts = b.comment("Starting health points measured in number of hearts.").defineInRange("startingHearts", 10, 1, 512);
        this.maxHeartContainers = b.comment("Maximum amount of Heart Containers one player can consume.\nDo note that the maximum health point is capped at value of 1024 (or 512 hearts) by Minecraft's default\nattribute system; without modifying these limits, Heart Containers won't give you extra hearts beyond that.").defineInRange("maxHeartContainers", 20, 0, 512);
        this.maxStamina = b.comment("Maximum amount of stamina Player can get. Do note that one third of this value is equal to one stamina wheel.").defineInRange("maxStamina", 3000, 0, Integer.MAX_VALUE);
        this.startingStamina = b.comment("Amount of stamina Player starts with. Values higher than maxStamina doesn't work.\nIf you want to make starting stamina displayed as one full stamina wheel, this value should be one third of maxStamina.").defineInRange("startingStamina", 1000, 0, Integer.MAX_VALUE);
        this.maxStaminaVessels = b.comment("Stamina Vessels players need to obtain max out stamina. More vessels means lesser stamina increase per vessel.").defineInRange("maxStaminaVessels", 10, 0, Integer.MAX_VALUE);
        b.pop();
        b.push("stamina");
        this.paraglidingConsumesStamina = b.comment("Paragliding will consume stamina.").define("paraglidingConsumesStamina", true);
        this.runningConsumesStamina = b.comment("Certain non-paragliding actions, such as running and swimming, will consume stamina.").define("runningAndSwimmingConsumesStamina", false);
        b.pop();
        this.paragliderInTowersOfTheWild = b.comment("Configurable option for Towers of the Wild compat feature. Can be ignored if Towers of the Wild is not installed.\nDEFAULT: Default option, spawn Deku Leaf in ocean tower chests and Paraglider in normal tower chests\nDISABLE: Don't spawn anything\nPARAGLIDER_ONLY: Spawn paraglider in both ocean and normal tower chests\nDEKU_LEAF_ONLY: Spawn deku leaf in both ocean and normal tower chests, like a boss").defineEnum("paragliderInTowersOfTheWild", (Enum)Cfg.TotwCompatConfigOption.DEFAULT);
        this.spec = b.build();
    }

    @Override
    public boolean ascendingWinds() {
        return (Boolean)LocalConfig.get(this.spec, this.ascendingWinds);
    }

    @Override
    @NotNull
    public BlockMatcher windSourceMatcher() {
        return this.windSourcesParsed == null ? BlockMatcher.empty() : this.windSourcesParsed;
    }

    @Override
    public double paraglidingSpeed() {
        return (Double)LocalConfig.get(this.spec, this.paraglidingSpeed);
    }

    @Override
    public int paragliderDurability() {
        return (Integer)LocalConfig.get(this.spec, this.paragliderDurability);
    }

    @Override
    public boolean enderDragonDropsVessel() {
        return (Boolean)LocalConfig.get(this.spec, this.enderDragonDropsVessel);
    }

    @Override
    public boolean witherDropsVessel() {
        return (Boolean)LocalConfig.get(this.spec, this.witherDropsVessel);
    }

    @Override
    public boolean raidGivesVessel() {
        return (Boolean)LocalConfig.get(this.spec, this.raidGivesVessel);
    }

    @Override
    public int spawnerSpiritOrbDrops() {
        return (Integer)LocalConfig.get(this.spec, this.spawnerSpiritOrbDrops);
    }

    @Override
    public boolean spiritOrbLoots() {
        return (Boolean)LocalConfig.get(this.spec, this.spiritOrbLoots);
    }

    @Override
    public int startingHearts() {
        return (Integer)LocalConfig.get(this.spec, this.startingHearts);
    }

    @Override
    public int maxHeartContainers() {
        return (Integer)LocalConfig.get(this.spec, this.maxHeartContainers);
    }

    @Override
    public int maxStamina() {
        return (Integer)LocalConfig.get(this.spec, this.maxStamina);
    }

    @Override
    public int startingStamina() {
        return (Integer)LocalConfig.get(this.spec, this.startingStamina);
    }

    @Override
    public int maxStaminaVessels() {
        return (Integer)LocalConfig.get(this.spec, this.maxStaminaVessels);
    }

    @Override
    public boolean paraglidingConsumesStamina() {
        return (Boolean)LocalConfig.get(this.spec, this.paraglidingConsumesStamina);
    }

    @Override
    public boolean runningConsumesStamina() {
        return (Boolean)LocalConfig.get(this.spec, this.runningConsumesStamina);
    }

    @Override
    @NotNull
    public Cfg.TotwCompatConfigOption paragliderInTowersOfTheWild() {
        return LocalConfig.get(this.spec, this.paragliderInTowersOfTheWild);
    }

    @NotNull
    private static <T> T get(@NotNull ForgeConfigSpec spec, @NotNull ForgeConfigSpec.ConfigValue<T> val) {
        return (T)(spec.isLoaded() ? val.get() : val.getDefault());
    }

    protected void reloadWindSources() {
        BlockMatcher.Result result = BlockMatcher.parse((Collection)this.windSources.get());
        result.printErrors();
        this.windSourcesParsed = result.result();
    }
}

