/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.chainConveyor;

import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ServerboundChainConveyorRidingPacket;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ChainConveyorRidingHandler {
    public static BlockPos ridingChainConveyor;
    public static float chainPosition;
    public static BlockPos ridingConnection;
    public static boolean flipped;
    public static int catchingUp;

    public static void embark(BlockPos lift, float position, BlockPos connection) {
        ridingChainConveyor = lift;
        chainPosition = position;
        ridingConnection = connection;
        catchingUp = 20;
        Minecraft mc = Minecraft.m_91087_();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(ridingChainConveyor);
        if (blockEntity instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
            flipped = clbe.getSpeed() < 0.0f;
        }
        MutableComponent component = Component.m_237110_((String)"mount.onboard", (Object[])new Object[]{mc.f_91066_.f_92090_.m_90863_()});
        mc.f_91065_.m_93063_((Component)component, false);
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11744_, (float)1.0f, (float)0.5f));
    }

    public static void clientTick() {
        Vec3 targetPosition;
        if (ridingChainConveyor == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (!AllTags.AllItemTags.CHAIN_RIDEABLE.matches(mc.f_91074_.m_21205_())) {
            ChainConveyorRidingHandler.stopRiding();
            return;
        }
        BlockEntity blockEntity = mc.f_91073_.m_7702_(ridingChainConveyor);
        if (mc.f_91074_.m_6144_() || !(blockEntity instanceof ChainConveyorBlockEntity)) {
            ChainConveyorRidingHandler.stopRiding();
            return;
        }
        ChainConveyorBlockEntity clbe = (ChainConveyorBlockEntity)blockEntity;
        if (ridingConnection != null && !clbe.connections.contains(ridingConnection)) {
            ChainConveyorRidingHandler.stopRiding();
            return;
        }
        clbe.prepareStats();
        Vec3 playerPosition = mc.f_91074_.m_20182_().m_82520_(0.0, mc.f_91074_.m_20191_().m_82376_() + 0.5, 0.0);
        ChainConveyorRidingHandler.updateTargetPosition(mc, clbe);
        blockEntity = mc.f_91073_.m_7702_(ridingChainConveyor);
        if (!(blockEntity instanceof ChainConveyorBlockEntity)) {
            return;
        }
        clbe = (ChainConveyorBlockEntity)blockEntity;
        clbe.prepareStats();
        if (ridingConnection != null) {
            ChainConveyorBlockEntity.ConnectionStats stats = clbe.connectionStats.get(ridingConnection);
            targetPosition = stats.start().m_82549_(stats.end().m_82546_(stats.start()).m_82541_().m_82490_((double)Math.min(stats.chainLength(), chainPosition)));
        } else {
            targetPosition = Vec3.m_82539_((Vec3i)ridingChainConveyor).m_82549_(VecHelper.rotate((Vec3)new Vec3(0.0, 0.25, 1.0), (double)chainPosition, (Direction.Axis)Direction.Axis.Y));
        }
        if (catchingUp > 0) {
            --catchingUp;
        }
        Vec3 diff = targetPosition.m_82546_(playerPosition);
        if (catchingUp == 0 && (diff.m_82553_() > 3.0 || diff.f_82480_ < -1.0)) {
            ChainConveyorRidingHandler.stopRiding();
            return;
        }
        mc.f_91074_.m_20256_(mc.f_91074_.m_20184_().m_82490_(0.75).m_82549_(diff.m_82490_(0.25)));
        if (AnimationTickHolder.getTicks() % 10 == 0) {
            AllPackets.getChannel().sendToServer((Object)new ServerboundChainConveyorRidingPacket(ridingChainConveyor, false));
        }
    }

    private static void stopRiding() {
        if (ridingChainConveyor != null) {
            AllPackets.getChannel().sendToServer((Object)new ServerboundChainConveyorRidingPacket(ridingChainConveyor, true));
        }
        ridingChainConveyor = null;
        ridingConnection = null;
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11744_, (float)0.75f, (float)0.35f));
    }

    private static void updateTargetPosition(Minecraft mc, ChainConveyorBlockEntity clbe) {
        float serverSpeed = ServerSpeedProvider.get();
        float speed = clbe.getSpeed() / 360.0f;
        float radius = 1.5f;
        float distancePerTick = Math.abs(speed);
        float degreesPerTick = speed / ((float)Math.PI * radius) * 360.0f;
        if (ridingConnection != null) {
            ChainConveyorBlockEntity.ConnectionStats stats = clbe.connectionStats.get(ridingConnection);
            if (flipped != clbe.getSpeed() < 0.0f) {
                flipped = clbe.getSpeed() < 0.0f;
                ridingChainConveyor = clbe.m_58899_().m_121955_((Vec3i)ridingConnection);
                chainPosition = stats.chainLength() - chainPosition;
                ridingConnection = ridingConnection.m_142393_(-1);
                return;
            }
            chainPosition += serverSpeed * distancePerTick;
            chainPosition = Math.min(stats.chainLength(), chainPosition);
            if (chainPosition < stats.chainLength()) {
                return;
            }
            BlockEntity blockEntity = mc.f_91073_.m_7702_(clbe.m_58899_().m_121955_((Vec3i)ridingConnection));
            if (blockEntity instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity clbe2 = (ChainConveyorBlockEntity)blockEntity;
                chainPosition = clbe.wrapAngle(stats.tangentAngle() + 180.0f + (float)(70 * (clbe.reversed ? -1 : 1)));
                ridingChainConveyor = clbe2.m_58899_();
                ridingConnection = null;
            }
            return;
        }
        float prevChainPosition = chainPosition;
        chainPosition += serverSpeed * degreesPerTick;
        chainPosition = clbe.wrapAngle(chainPosition);
        BlockPos nearestLooking = BlockPos.f_121853_;
        double bestDiff = Double.MAX_VALUE;
        for (BlockPos connection : clbe.connections) {
            double diff = Vec3.m_82528_((Vec3i)connection).m_82541_().m_82557_(mc.f_91074_.m_20154_().m_82541_());
            if (diff > bestDiff) continue;
            nearestLooking = connection;
            bestDiff = diff;
        }
        if (nearestLooking == BlockPos.f_121853_) {
            return;
        }
        float offBranchAngle = clbe.connectionStats.get(nearestLooking).tangentAngle();
        if (!clbe.loopThresholdCrossed(chainPosition, prevChainPosition, offBranchAngle)) {
            return;
        }
        chainPosition = 0.0f;
        ridingConnection = nearestLooking;
    }
}

