/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Surface
extends BaseMode {
    public Surface(boolean isExchanging) {
        super(isExchanging);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "surface");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        int range = GadgetNBT.getToolRange(gadget);
        int bound = range / 2;
        Level level = player.m_9236_();
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        BlockState lookingAtState = level.m_8055_(start);
        BlockPos startAt = this.isExchanging ? start : start.m_121945_(hitSide);
        AABB box = GadgetUtils.getSquareArea(startAt, hitSide, bound);
        BlockPos.m_121921_((AABB)box).map(BlockPos::m_7949_).forEach(pos -> {
            if (this.isPosValid(level, player, (BlockPos)pos, state) && this.isPosValidCustom(level, (BlockPos)pos, lookingAtState, gadget, hitSide)) {
                coordinates.add(new StatePos(state, pos.m_121996_((Vec3i)start)));
            }
        });
        boolean connected = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.CONNECTED_AREA.value);
        if (this.isExchanging && connected) {
            return this.removeUnConnected(level, player, startAt.m_121996_((Vec3i)start), coordinates, hitSide);
        }
        return coordinates;
    }

    public boolean isPosValidCustom(Level level, BlockPos pos, BlockState compareState, ItemStack gadget, Direction hitSide) {
        if (this.isExchanging) {
            return true;
        }
        boolean fuzzy = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.FUZZY.value);
        BlockState belowState = level.m_8055_(pos.m_121945_(hitSide.m_122424_()));
        return !(fuzzy ? belowState.m_60795_() : !belowState.equals(compareState));
    }
}

