/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EventHelpers {
    public static boolean mayExchange(Level level, Player player, BlockPos pos) {
        return level.m_7966_(player, pos) && EventHelpers._canBreak(level, player, pos) && EventHelpers._mayPlace(level, player, pos);
    }

    public static boolean mayPlace(Level level, Player player, @NotNull BlockPos pos) {
        return level.m_7966_(player, pos) && EventHelpers._mayPlace(level, player, pos);
    }

    public static boolean canBreak(Level level, Player player, @NotNull BlockPos pos) {
        return level.m_7966_(player, pos) && EventHelpers._canBreak(level, player, pos);
    }

    private static boolean _mayPlace(Level level, Player player, @NotNull BlockPos pos) {
        BlockState placedAgainst;
        BlockSnapshot blockSnapshot = BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(blockSnapshot, placedAgainst = Objects.requireNonNull(blockSnapshot.getLevel()).m_8055_(blockSnapshot.getPos()), (Entity)player);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private static boolean _canBreak(Level level, Player player, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(level, pos, state, player);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

