/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.capabilities.CapabilityEnergyProvider;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MagicHelpers;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseGadget
extends Item {
    public BaseGadget() {
        super(new Item.Properties().m_41487_(1));
    }

    public abstract int getEnergyMax();

    public abstract int getEnergyCost();

    public int getMaxDamage(ItemStack stack) {
        return this.getEnergyMax();
    }

    public boolean m_142522_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityEnergyProvider(stack, this.getEnergyMax());
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY, null).map(e -> Math.min(13 * e.getEnergyStored() / e.getMaxEnergyStored(), 13)).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(e -> Mth.m_14169_((float)(Math.max(0.0f, (float)e.getEnergyStored() / (float)e.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f)).orElse(super.m_142159_(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        boolean sneakPressed = Screen.m_96638_();
        if (!sneakPressed) {
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.holdshift", (Object[])new Object[]{"shift"}).m_130940_(ChatFormatting.GRAY));
        } else {
            DimBlockPos boundTo = GadgetNBT.getBoundPos(stack);
            if (boundTo != null) {
                tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.tooltips.boundto", (Object[])new Object[]{boundTo.levelKey.m_135782_().m_135815_(), "[" + boundTo.blockPos.m_123344_() + "]"}).m_6270_(Styles.GOLD));
            }
        }
        stack.getCapability(ForgeCapabilities.ENERGY, null).ifPresent(energy -> {
            MutableComponent energyText = !sneakPressed ? Component.m_237110_((String)"buildinggadgets2.tooltips.energy", (Object[])new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}) : Component.m_237110_((String)"buildinggadgets2.tooltips.energy", (Object[])new Object[]{String.format("%,d", energy.getEnergyStored()), String.format("%,d", energy.getMaxEnergyStored())});
            tooltip.add((Component)energyText.m_130940_(ChatFormatting.GREEN));
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack gadget = player.m_21120_(hand);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)gadget);
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        if (level.m_8055_(lookingAt.m_82425_()).m_60795_() && GadgetNBT.getAnchorPos(gadget).equals((Object)GadgetNBT.nullPos)) {
            return InteractionResultHolder.m_19090_((Object)gadget);
        }
        ItemActionContext context = new ItemActionContext(lookingAt.m_82425_(), lookingAt, player, level, hand, gadget);
        if (player.m_6144_()) {
            if (GadgetNBT.getSetting(gadget, "bind")) {
                if (this.bindToInventory(level, player, gadget, lookingAt)) {
                    GadgetNBT.toggleSetting(gadget, "bind");
                    return InteractionResultHolder.m_19090_((Object)gadget);
                }
                return InteractionResultHolder.m_19100_((Object)gadget);
            }
            return this.onShiftAction(context);
        }
        return this.onAction(context);
    }

    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        return InteractionResultHolder.m_19098_((Object)context.stack());
    }

    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        return InteractionResultHolder.m_19098_((Object)context.stack());
    }

    public boolean bindToInventory(Level level, Player player, ItemStack gadget, BlockHitResult lookingAt) {
        LazyOptional handler;
        BlockEntity blockEntity = level.m_7702_(lookingAt.m_82425_());
        if (blockEntity != null && (handler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, lookingAt.m_82434_())).isPresent()) {
            GadgetNBT.setBoundPos(gadget, new DimBlockPos(level, lookingAt.m_82425_()));
            GadgetNBT.setToolValue(gadget, lookingAt.m_82434_().ordinal(), "binddirection");
            player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.bindsuccess", (Object[])new Object[]{lookingAt.m_82425_().m_123344_()}), true);
            return true;
        }
        DimBlockPos existingBind = GadgetNBT.getBoundPos(gadget);
        if (existingBind != null) {
            GadgetNBT.clearBoundPos(gadget);
            player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.bindremoved"), true);
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.bindfailed"), true);
        return false;
    }

    public ResourceLocation rotateModes(ItemStack stack) {
        BaseMode currentMode;
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(this.gadgetTarget());
        ArrayList<BaseMode> arrayOfModes = new ArrayList<BaseMode>((Collection<BaseMode>)modesForGadget);
        int modeIndex = arrayOfModes.indexOf(currentMode = GadgetNBT.getMode(stack));
        if (modeIndex == -1 || ++modeIndex > arrayOfModes.size()) {
            modeIndex = 0;
        }
        BaseMode mode = arrayOfModes.get(modeIndex);
        GadgetNBT.setMode(stack, mode);
        return mode.getId();
    }

    public abstract GadgetTarget gadgetTarget();

    public static ItemStack getGadget(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BaseGadget) && !((heldItem = player.m_21206_()).m_41720_() instanceof BaseGadget)) {
            return ItemStack.f_41583_;
        }
        return heldItem;
    }

    public static BlockPos getHitPos(ItemActionContext context) {
        BlockPos anchorPos = GadgetNBT.getAnchorPos(context.stack());
        return anchorPos.equals((Object)GadgetNBT.nullPos) ? context.pos() : anchorPos;
    }

    public boolean canUndo(Level level, Player player, ItemStack gadget) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        ArrayList<StatePos> undoList = bg2Data.peekUndoList(GadgetNBT.peekUndoList(gadget));
        for (StatePos statePos : undoList) {
            if (level.m_46749_(statePos.pos)) continue;
            player.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.undofailedunloaded", (Object[])new Object[]{statePos.pos.m_123344_()}), true);
            return false;
        }
        return true;
    }

    public void undo(Level level, Player player, ItemStack gadget) {
        if (!this.canUndo(level, player, gadget)) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        UUID buildUUID = GadgetNBT.popUndoList(gadget);
        ServerTickHandler.stopBuilding(buildUUID);
        ArrayList<StatePos> undoList = bg2Data.popUndoList(buildUUID);
        if (undoList.isEmpty()) {
            return;
        }
        Collections.reverse(undoList);
        ArrayList<BlockPos> todoList = new ArrayList<BlockPos>();
        for (StatePos statePos : undoList) {
            todoList.add(statePos.pos);
        }
        boolean giveItemsBack = !player.m_7500_();
        BuildingUtils.removeTickHandler(level, player, todoList, giveItemsBack, giveItemsBack, gadget);
    }
}

