/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import io.github.projectet.ae2things.client.AE2ThingsClient;
import io.github.projectet.ae2things.command.Command;
import io.github.projectet.ae2things.gui.cell.DISKItemCellGuiHandler;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.util.StorageManager;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="ae2things")
public class AE2Things {
    public static final String MOD_ID = "ae2things";
    public static StorageManager STORAGE_INSTANCE = new StorageManager();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ae2things");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public AE2Things() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        AETItems.init();
        modEventBus.addListener(AE2Things::commonSetup);
        modEventBus.addListener(AE2Things::addContentsToCreativeTab);
        MinecraftForge.EVENT_BUS.addListener(Command::commandRegister);
        MinecraftForge.EVENT_BUS.addListener(AE2Things::worldTick);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> AE2ThingsClient::init);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        AETItems.commonSetup();
        StorageCells.addCellHandler((ICellHandler)DISKCellHandler.INSTANCE);
        StorageCells.addCellGuiHandler((ICellGuiHandler)new DISKItemCellGuiHandler());
        event.enqueueWork(() -> {
            String disksText = "text.ae2things.disk_drives";
            for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
                Upgrades.add((ItemLike)AEItems.FUZZY_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, (ItemLike)((ItemLike)cell.get()), (int)1, (String)disksText);
            }
        });
    }

    public static void addContentsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (!event.getTabKey().equals((Object)AECreativeTabIds.MAIN)) {
            return;
        }
        event.accept(AETItems.DISK_HOUSING);
        for (Supplier<Item> cell : AETItems.DISK_DRIVES) {
            event.accept(cell);
        }
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isServer()) {
            STORAGE_INSTANCE = StorageManager.getInstance(event.level.m_7654_());
        }
    }
}

