/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.registry;

import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalGeneration;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="environmental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnvironmentalBiomes {
    public static final ResourceKey<Biome> MARSH = EnvironmentalBiomes.createKey("marsh");
    public static final ResourceKey<Biome> BLOSSOM_WOODS = EnvironmentalBiomes.createKey("blossom_woods");
    public static final ResourceKey<Biome> BLOSSOM_VALLEYS = EnvironmentalBiomes.createKey("blossom_valleys");
    public static final ResourceKey<Biome> PINE_BARRENS = EnvironmentalBiomes.createKey("pine_barrens");
    public static final ResourceKey<Biome> SNOWY_PINE_BARRENS = EnvironmentalBiomes.createKey("snowy_pine_barrens");
    public static final ResourceKey<Biome> OLD_GROWTH_PINE_BARRENS = EnvironmentalBiomes.createKey("old_growth_pine_barrens");
    public static final ResourceKey<Biome> SNOWY_OLD_GROWTH_PINE_BARRENS = EnvironmentalBiomes.createKey("snowy_old_growth_pine_barrens");
    public static final ResourceKey<Biome> PINE_SLOPES = EnvironmentalBiomes.createKey("pine_slopes");
    public static final List<ResourceKey<Biome>> NATURAL_BIOMES = List.of(MARSH, BLOSSOM_WOODS, BLOSSOM_VALLEYS, PINE_BARRENS, SNOWY_PINE_BARRENS, OLD_GROWTH_PINE_BARRENS, SNOWY_OLD_GROWTH_PINE_BARRENS, PINE_SLOPES);

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter carvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(MARSH, (Object)EnvironmentalBiomes.marsh((HolderGetter<PlacedFeature>)features, carvers));
        context.m_255272_(BLOSSOM_WOODS, (Object)EnvironmentalBiomes.blossomBiome((HolderGetter<PlacedFeature>)features, carvers, false));
        context.m_255272_(BLOSSOM_VALLEYS, (Object)EnvironmentalBiomes.blossomBiome((HolderGetter<PlacedFeature>)features, carvers, true));
        context.m_255272_(PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, false, false));
        context.m_255272_(SNOWY_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, true, false));
        context.m_255272_(OLD_GROWTH_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, false, true));
        context.m_255272_(SNOWY_OLD_GROWTH_PINE_BARRENS, (Object)EnvironmentalBiomes.pineBarrens((HolderGetter<PlacedFeature>)features, carvers, true, true));
        context.m_255272_(PINE_SLOPES, (Object)EnvironmentalBiomes.pineSlopes((HolderGetter<PlacedFeature>)features, carvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)Environmental.location(name));
    }

    private static Biome marsh(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.marsh(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, 0.8f, 0.9f, 6263617, 6975545, 6134398, 2302743, 12638463, spawns, generation, Musics.m_263184_((Holder)SoundEvents.f_215730_));
    }

    private static Biome blossomBiome(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean valley) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.blossomWoods(generation, valley);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 1, 1, 2));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.KOI.get(), 8, 1, 1));
        return EnvironmentalBiomes.biome(true, 0.45f, 0.8f, 5938278, 5216182, 335411, spawns, generation, null);
    }

    private static Biome pineBarrens(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers, boolean snowy, boolean oldGrowth) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.pineBarrens(generation, snowy, oldGrowth);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawns);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, snowy ? -0.2f : 0.4f, snowy ? 0.4f : 0.6f, snowy ? 8828286 : (oldGrowth ? 9221482 : 9484136), snowy ? 6789454 : 7578444, 4159204, 329011, 12638463, spawns, generation, null);
    }

    private static Biome pineSlopes(HolderGetter<PlacedFeature> features, HolderGetter<ConfiguredWorldCarver<?>> carvers) {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder(features, carvers);
        EnvironmentalGeneration.pineSlopes(generation);
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawns);
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3));
        return EnvironmentalBiomes.biome(true, 0.4f, 0.3f, 4159204, 329011, spawns, generation, null);
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int foliageColor, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static Biome biome(boolean precipitation, float temperature, float downfall, int grassColor, int foliageColor, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder spawns, BiomeGenerationSettings.Builder generation, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(EnvironmentalBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(generation.m_255380_()).m_47592_();
    }

    private static int calculateSkyColor(float temperature) {
        float clampedTemp = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - clampedTemp * 0.05f), (float)(0.5f + clampedTemp * 0.1f), (float)1.0f);
    }
}

