/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.server.modifiers;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBiomeTags;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.tags.EnvironmentalBiomeTags;
import com.teamabnormals.environmental.core.registry.EnvironmentalBiomeModifierTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalEntityTypes;
import com.teamabnormals.environmental.core.registry.EnvironmentalFeatures;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class EnvironmentalBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        EnvironmentalBiomeModifiers.addSpawn(context, "slabfish", EnvironmentalBiomeTags.HAS_SLABFISH, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.SLABFISH.get(), 12, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "duck", EnvironmentalBiomeTags.HAS_DUCK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "duck_rare", (ResourceKey<Biome>)Biomes.f_48208_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DUCK.get(), 1, 1, 2));
        EnvironmentalBiomeModifiers.addSpawnIgnore(context, "deer", EnvironmentalBiomeTags.HAS_DEER, EnvironmentalBiomeTags.WITHOUT_DEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "reindeer", EnvironmentalBiomeTags.HAS_REINDEER, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.REINDEER.get(), 10, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "tapir", EnvironmentalBiomeTags.HAS_TAPIR, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 10, 2, 2));
        EnvironmentalBiomeModifiers.addSpawn(context, "tapir_rare", (ResourceKey<Biome>)Biomes.f_186769_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.TAPIR.get(), 4, 2, 2));
        EnvironmentalBiomeModifiers.addSpawn(context, "yak", EnvironmentalBiomeTags.HAS_YAK, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.YAK.get(), 8, 4, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "deer_meadow", (ResourceKey<Biome>)Biomes.f_186754_, new MobSpawnSettings.SpawnerData((EntityType)EnvironmentalEntityTypes.DEER.get(), 1, 2, 4));
        EnvironmentalBiomeModifiers.addSpawn(context, "pig", (ResourceKey<Biome>)Biomes.f_220595_, new MobSpawnSettings.SpawnerData(EntityType.f_20510_, 10, 4, 4));
        EnvironmentalBiomeModifiers.addFeature(context, "zebra_dazzle", EnvironmentalBiomeTags.HAS_ZEBRA, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.ZEBRA_DAZZLE);
        EnvironmentalBiomeModifiers.removeSpawnInvertedIgnore(context, "pig", EnvironmentalBiomeTags.HAS_PIG, (ResourceKey<Biome>)Biomes.f_186755_, EntityType.f_20510_);
        EnvironmentalBiomeModifiers.removeSpawnInverted(context, "sheep", EnvironmentalBiomeTags.HAS_SHEEP, EntityType.f_20520_);
        EnvironmentalBiomeModifiers.removeSpawnInverted(context, "cow", EnvironmentalBiomeTags.HAS_COW, EntityType.f_20557_);
        EnvironmentalBiomeModifiers.removeSpawnInvertedIgnore(context, "chicken", EnvironmentalBiomeTags.HAS_CHICKEN, (ResourceKey<Biome>)Biomes.f_186755_, EntityType.f_20555_);
        EnvironmentalBiomeModifiers.addFeature(context, "cattails", EnvironmentalBiomeTags.HAS_CATTAILS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.CATTAILS);
        EnvironmentalBiomeModifiers.addFeature(context, "cup_lichen", EnvironmentalBiomeTags.HAS_CUP_LICHEN, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_CUP_LICHEN_TAIGA);
        EnvironmentalBiomeModifiers.addFeatureIgnore(context, "dwarf_spruce_sparse", EnvironmentalBiomeTags.HAS_SPARSE_DWARF_SPRUCE, EnvironmentalBiomeTags.IS_PINE_BARRENS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.DWARF_SPRUCE_SPARSE);
        EnvironmentalBiomeModifiers.addFeature(context, "bluebell", EnvironmentalBiomeTags.HAS_BLUEBELL, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BLUEBELL, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BLUEBELL_LARGE);
        EnvironmentalBiomeModifiers.addFeature(context, "violet", EnvironmentalBiomeTags.HAS_VIOLET, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_VIOLET);
        EnvironmentalBiomeModifiers.addFeature(context, "tasselflower", EnvironmentalBiomeTags.HAS_TASSELFLOWER, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_TASSELFLOWER);
        EnvironmentalBiomeModifiers.addFeature(context, "bird_of_paradise", EnvironmentalBiomeTags.HAS_BIRD_OF_PARADISE, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_BIRD_OF_PARADISE);
        EnvironmentalBiomeModifiers.addFeature(context, "hibiscus_bush", EnvironmentalBiomeTags.HAS_HIBISCUS, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.HIBISCUS_BUSH);
        EnvironmentalBiomeModifiers.addFeature(context, "cartwheel", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.FLOWER_CARTWHEEL);
        EnvironmentalBiomeModifiers.addFeature(context, "mycelium_sprouts", (ResourceKey<Biome>)Biomes.f_48215_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_MYCELIUM_SPROUTS);
        EnvironmentalBiomeModifiers.addFeature(context, "mud_disk", EnvironmentalBiomeTags.HAS_MUD_DISK, GenerationStep.Decoration.UNDERGROUND_ORES, EnvironmentalFeatures.EnvironmentalPlacedFeatures.ORE_MUD);
        EnvironmentalBiomeModifiers.removeFeature(context, "swamp_oak", (ResourceKey<Biome>)Biomes.f_48207_, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195432_);
        EnvironmentalBiomeModifiers.addFeature(context, "swamp_vegetation", (ResourceKey<Biome>)Biomes.f_48207_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_SWAMP, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DUCKWEED_SWAMP);
        EnvironmentalBiomeModifiers.addFeature(context, "flower_forest_vegetation", (ResourceKey<Biome>)Biomes.f_48179_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_DELPHINIUMS, EnvironmentalFeatures.EnvironmentalPlacedFeatures.TREES_WISTERIA);
        EnvironmentalBiomeModifiers.addFeature(context, "savanna_vegetation", (TagKey<Biome>)BiomeTags.f_215816_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_SAVANNA);
        EnvironmentalBiomeModifiers.addFeature(context, "plains_vegetation", (TagKey<Biome>)BlueprintBiomeTags.IS_GRASSLAND, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_PLAINS);
        EnvironmentalBiomeModifiers.addFeature(context, "jungle_vegetation", (TagKey<Biome>)BiomeTags.f_207610_, GenerationStep.Decoration.VEGETAL_DECORATION, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_GIANT_TALL_GRASS_JUNGLE, EnvironmentalFeatures.EnvironmentalPlacedFeatures.PATCH_LARGE_FERN_JUNGLE);
    }

    @SafeVarargs
    private static void removeFeature(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "remove_feature/" + name, () -> new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), EnvironmentalBiomeModifiers.featureSet(context, features), Set.of(step)));
    }

    private static void removeSpawnInverted(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        EnvironmentalBiomeModifiers.register(context, "remove_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<EntityType<?>>)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    private static void removeSpawnInvertedIgnore(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, ResourceKey<Biome> ignoredBiome, EntityType<?> ... types) {
        EnvironmentalBiomeModifiers.register(context, "remove_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.InvertedRemoveSpawnsIgnoreBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(ignoredBiome)}), (HolderSet<EntityType<?>>)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    @SafeVarargs
    private static void addFeatureIgnore(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> ignoredBiomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new EnvironmentalBiomeModifierTypes.AddFeaturesIgnoreBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(ignoredBiomes), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EnvironmentalBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), EnvironmentalBiomeModifiers.featureSet(context, features), step));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), List.of(spawns)));
    }

    private static void addSpawnIgnore(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, TagKey<Biome> ignoredBiome, MobSpawnSettings.SpawnerData ... spawns) {
        EnvironmentalBiomeModifiers.register(context, "add_spawn/" + name, () -> new EnvironmentalBiomeModifierTypes.AddSpawnsIgnoreBiomeModifier((HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet<Biome>)context.m_255420_(Registries.f_256952_).m_254956_(ignoredBiome), List.of(spawns)));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Environmental.location(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(key -> context.m_255420_(Registries.f_256988_).m_255043_(key)).collect(Collectors.toList()));
    }
}

