/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core.data.client;

import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import com.teamabnormals.environmental.common.block.CattailBlock;
import com.teamabnormals.environmental.common.block.CattailStalkBlock;
import com.teamabnormals.environmental.core.Environmental;
import com.teamabnormals.environmental.core.other.EnvironmentalBlockFamilies;
import com.teamabnormals.environmental.core.registry.EnvironmentalBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class EnvironmentalBlockStateProvider
extends BlueprintBlockStateProvider {
    public static final String[] WISTERIA_BOOKSHELF_POSITIONS = new String[]{"outer_left", "mid_left", "inner_left", "inner_right", "mid_right", "outer_right"};

    public EnvironmentalBlockStateProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "environmental", helper);
    }

    protected void registerStatesAndModels() {
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_BRICK_FAMILY);
        this.blockFamily(EnvironmentalBlockFamilies.DIRT_TILE_FAMILY);
        this.blockFamily(EnvironmentalBlockFamilies.WILLOW_PLANKS_FAMILY);
        this.logBlocks(EnvironmentalBlocks.WILLOW_LOG, EnvironmentalBlocks.WILLOW_WOOD);
        this.logBlocks(EnvironmentalBlocks.STRIPPED_WILLOW_LOG, EnvironmentalBlocks.STRIPPED_WILLOW_WOOD);
        this.hangingSignBlocks(EnvironmentalBlocks.STRIPPED_WILLOW_LOG, EnvironmentalBlocks.WILLOW_HANGING_SIGNS);
        this.leavesBlocks(EnvironmentalBlocks.WILLOW_LEAVES, EnvironmentalBlocks.WILLOW_LEAF_PILE);
        this.crossBlockWithPot(EnvironmentalBlocks.WILLOW_SAPLING, EnvironmentalBlocks.POTTED_WILLOW_SAPLING);
        this.woodworksBlocks(EnvironmentalBlocks.WILLOW_PLANKS, EnvironmentalBlocks.WILLOW_BOARDS, EnvironmentalBlocks.WILLOW_LADDER, EnvironmentalBlocks.WILLOW_BOOKSHELF, EnvironmentalBlocks.WILLOW_BEEHIVE, EnvironmentalBlocks.WILLOW_CHEST, EnvironmentalBlocks.TRAPPED_WILLOW_CHEST);
        this.chiseledBookshelfBlock(EnvironmentalBlocks.CHISELED_WILLOW_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.blockFamily(EnvironmentalBlockFamilies.PINE_PLANKS_FAMILY);
        this.logBlocks(EnvironmentalBlocks.PINE_LOG, EnvironmentalBlocks.PINE_WOOD);
        this.logBlocks(EnvironmentalBlocks.STRIPPED_PINE_LOG, EnvironmentalBlocks.STRIPPED_PINE_WOOD);
        this.hangingSignBlocks(EnvironmentalBlocks.STRIPPED_PINE_LOG, EnvironmentalBlocks.PINE_HANGING_SIGNS);
        this.leavesBlocks(EnvironmentalBlocks.PINE_LEAVES, EnvironmentalBlocks.PINE_LEAF_PILE);
        this.crossBlockWithPot(EnvironmentalBlocks.PINE_SAPLING, EnvironmentalBlocks.POTTED_PINE_SAPLING);
        this.woodworksBlocks(EnvironmentalBlocks.PINE_PLANKS, EnvironmentalBlocks.PINE_BOARDS, EnvironmentalBlocks.PINE_LADDER, EnvironmentalBlocks.PINE_BOOKSHELF, EnvironmentalBlocks.PINE_BEEHIVE, EnvironmentalBlocks.PINE_CHEST, EnvironmentalBlocks.TRAPPED_PINE_CHEST);
        this.chiseledBookshelfBlock(EnvironmentalBlocks.CHISELED_PINE_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.cubeColumnBlock(EnvironmentalBlocks.PINECONE);
        this.cubeColumnBlock(EnvironmentalBlocks.WAXED_PINECONE, EnvironmentalBlocks.PINECONE);
        this.blockFamily(EnvironmentalBlockFamilies.PLUM_PLANKS_FAMILY);
        this.logBlocks(EnvironmentalBlocks.PLUM_LOG, EnvironmentalBlocks.PLUM_WOOD);
        this.logBlocks(EnvironmentalBlocks.STRIPPED_PLUM_LOG, EnvironmentalBlocks.STRIPPED_PLUM_WOOD);
        this.hangingSignBlocks(EnvironmentalBlocks.STRIPPED_PLUM_LOG, EnvironmentalBlocks.PLUM_HANGING_SIGNS);
        this.leavesBlocks(EnvironmentalBlocks.PLUM_LEAVES, EnvironmentalBlocks.PLUM_LEAF_PILE);
        this.leavesBlocks(EnvironmentalBlocks.CHEERFUL_PLUM_LEAVES, EnvironmentalBlocks.CHEERFUL_PLUM_LEAF_PILE);
        this.leavesBlocks(EnvironmentalBlocks.MOODY_PLUM_LEAVES, EnvironmentalBlocks.MOODY_PLUM_LEAF_PILE);
        this.crossBlockWithPot(EnvironmentalBlocks.PLUM_SAPLING, EnvironmentalBlocks.POTTED_PLUM_SAPLING);
        this.crossBlockWithPot(EnvironmentalBlocks.CHEERFUL_PLUM_SAPLING, EnvironmentalBlocks.POTTED_CHEERFUL_PLUM_SAPLING);
        this.crossBlockWithPot(EnvironmentalBlocks.MOODY_PLUM_SAPLING, EnvironmentalBlocks.POTTED_MOODY_PLUM_SAPLING);
        this.woodworksBlocks(EnvironmentalBlocks.PLUM_PLANKS, EnvironmentalBlocks.PLUM_BOARDS, EnvironmentalBlocks.PLUM_LADDER, EnvironmentalBlocks.PLUM_BOOKSHELF, EnvironmentalBlocks.PLUM_BEEHIVE, EnvironmentalBlocks.PLUM_CHEST, EnvironmentalBlocks.TRAPPED_PLUM_CHEST);
        this.chiseledBookshelfBlock(EnvironmentalBlocks.CHISELED_PLUM_BOOKSHELF, DEFAULT_BOOKSHELF_POSITIONS);
        this.blockFamily(EnvironmentalBlockFamilies.WISTERIA_PLANKS_FAMILY);
        this.logBlocks(EnvironmentalBlocks.WISTERIA_LOG, EnvironmentalBlocks.WISTERIA_WOOD);
        this.logBlocks(EnvironmentalBlocks.STRIPPED_WISTERIA_LOG, EnvironmentalBlocks.STRIPPED_WISTERIA_WOOD);
        this.hangingSignBlocks(EnvironmentalBlocks.STRIPPED_WISTERIA_LOG, EnvironmentalBlocks.WISTERIA_HANGING_SIGNS);
        this.leavesBlocks(EnvironmentalBlocks.WISTERIA_LEAVES, EnvironmentalBlocks.WISTERIA_LEAF_PILE);
        this.crossBlockWithPot(EnvironmentalBlocks.PINK_WISTERIA_SAPLING, EnvironmentalBlocks.POTTED_PINK_WISTERIA_SAPLING);
        this.crossBlockWithPot(EnvironmentalBlocks.BLUE_WISTERIA_SAPLING, EnvironmentalBlocks.POTTED_BLUE_WISTERIA_SAPLING);
        this.crossBlockWithPot(EnvironmentalBlocks.PURPLE_WISTERIA_SAPLING, EnvironmentalBlocks.POTTED_PURPLE_WISTERIA_SAPLING);
        this.crossBlockWithPot(EnvironmentalBlocks.WHITE_WISTERIA_SAPLING, EnvironmentalBlocks.POTTED_WHITE_WISTERIA_SAPLING);
        this.woodworksBlocks(EnvironmentalBlocks.WISTERIA_PLANKS, EnvironmentalBlocks.WISTERIA_BOARDS, EnvironmentalBlocks.WISTERIA_LADDER, EnvironmentalBlocks.WISTERIA_BOOKSHELF, EnvironmentalBlocks.WISTERIA_BEEHIVE, EnvironmentalBlocks.WISTERIA_CHEST, EnvironmentalBlocks.TRAPPED_WISTERIA_CHEST);
        this.leafPileBlock(EnvironmentalBlocks.PINK_WISTERIA_LEAVES, EnvironmentalBlocks.PINK_WISTERIA_LEAF_PILE);
        this.leafPileBlock(EnvironmentalBlocks.BLUE_WISTERIA_LEAVES, EnvironmentalBlocks.BLUE_WISTERIA_LEAF_PILE);
        this.leafPileBlock(EnvironmentalBlocks.PURPLE_WISTERIA_LEAVES, EnvironmentalBlocks.PURPLE_WISTERIA_LEAF_PILE);
        this.leafPileBlock(EnvironmentalBlocks.WHITE_WISTERIA_LEAVES, EnvironmentalBlocks.WHITE_WISTERIA_LEAF_PILE);
        this.chiseledBookshelfBlock(EnvironmentalBlocks.CHISELED_WISTERIA_BOOKSHELF, WISTERIA_BOOKSHELF_POSITIONS);
        this.leavesBlocks(EnvironmentalBlocks.HIBISCUS_LEAVES, EnvironmentalBlocks.HIBISCUS_LEAF_PILE);
        this.block(EnvironmentalBlocks.CATTAIL_FLUFF_BLOCK);
        this.cattail(EnvironmentalBlocks.CATTAIL_SPROUT, EnvironmentalBlocks.CATTAIL, EnvironmentalBlocks.CATTAIL_STALK);
        this.block(EnvironmentalBlocks.BURIED_TRUFFLE);
        this.block(EnvironmentalBlocks.CHISELED_MUD_BRICKS);
        this.directionalBlock(EnvironmentalBlocks.CHERRY_CRATE);
        this.directionalBlock(EnvironmentalBlocks.PLUM_CRATE);
        this.cubeBottomTopBlock(EnvironmentalBlocks.DUCK_EGG_CRATE);
        this.crossBlock(EnvironmentalBlocks.MYCELIUM_SPROUTS);
        this.cactusBobble(EnvironmentalBlocks.CACTUS_BOBBLE);
        this.crossBlockWithPot(EnvironmentalBlocks.BLUEBELL, EnvironmentalBlocks.POTTED_BLUEBELL);
        this.crossBlockWithPot(EnvironmentalBlocks.DIANTHUS, EnvironmentalBlocks.POTTED_DIANTHUS);
        this.crossBlockWithPot(EnvironmentalBlocks.VIOLET, EnvironmentalBlocks.POTTED_VIOLET);
        this.crossBlockWithPot(EnvironmentalBlocks.TASSELFLOWER, EnvironmentalBlocks.POTTED_TASSELFLOWER);
        this.crossBlockWithPot(EnvironmentalBlocks.WHITE_LOTUS_FLOWER, EnvironmentalBlocks.POTTED_WHITE_LOTUS_FLOWER);
        this.crossBlockWithPot(EnvironmentalBlocks.RED_LOTUS_FLOWER, EnvironmentalBlocks.POTTED_RED_LOTUS_FLOWER);
    }

    public void leavesBlock(RegistryObject<Block> leaves) {
        this.simpleBlock((Block)leaves.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(EnvironmentalBlockStateProvider.name((Block)((Block)leaves.get())))).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("block/leaves")))).texture("all", this.blockTexture((Block)leaves.get())));
        this.blockItem(leaves);
    }

    public void cubeColumnBlock(RegistryObject<Block> block) {
        this.cubeColumnBlock(block, block);
    }

    public void cubeColumnBlock(RegistryObject<Block> block, RegistryObject<Block> parent) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.models().cubeColumn(EnvironmentalBlockStateProvider.name((Block)((Block)block.get())), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)parent.get()), (String)"_side"), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture((Block)parent.get()), (String)"_end")));
        this.blockItem(block);
    }

    public void cattail(RegistryObject<Block> cattailSproutObject, RegistryObject<Block> cattailObject, RegistryObject<Block> cattailStalkObject) {
        Block cattailSprout = (Block)cattailSproutObject.get();
        Block cattail = (Block)cattailObject.get();
        Block cattailStalk = (Block)cattailStalkObject.get();
        this.getVariantBuilder(cattailSprout).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattailSprout), this.blockTexture(cattailSprout), (Integer)state.m_61143_((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.f_61362_});
        MultiPartBlockStateBuilder cattailBuilder = this.getMultipartBuilder(cattail);
        for (int i = 1; i <= 3; ++i) {
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)cattailBuilder.part().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattail), this.blockTexture(cattail), i, false)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_top", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_stalk_top"), i, true)).addModel()).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head_fluffy", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head_fluffy"), false, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{false}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end().part().modelFile(this.cattailHeadModel(EnvironmentalBlockStateProvider.name((Block)cattail) + "_head_fluffy", EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattail), (String)"_head_fluffy"), true, i)).addModel()).condition((Property)CattailBlock.FLUFFY, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.TOP, (Comparable[])new Boolean[]{true}).condition((Property)CattailBlock.CATTAILS, (Comparable[])new Integer[]{i}).end();
        }
        this.getVariantBuilder(cattailStalk).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.cattailStalkModel(EnvironmentalBlockStateProvider.name((Block)cattailStalk) + ((Boolean)state.m_61143_((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle"), EnvironmentalBlockStateProvider.suffix((ResourceLocation)this.blockTexture(cattailStalk), (String)((Boolean)state.m_61143_((Property)CattailStalkBlock.BOTTOM) != false ? "_bottom" : "_middle")), (Integer)state.m_61143_((Property)CattailBlock.CATTAILS), false)).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    public ModelFile cattailStalkModel(String name, ResourceLocation texture, int stalks, boolean top) {
        String stalkSuffix = EnvironmentalBlockStateProvider.getStalkSuffix(stalks);
        ModelFile.UncheckedModelFile stalkParent = new ModelFile.UncheckedModelFile(Environmental.location("block/template_cattail_stalk" + stalkSuffix));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + stalkSuffix)).parent((ModelFile)stalkParent);
        for (int i = 1; i <= stalks; ++i) {
            String suffix = EnvironmentalBlockStateProvider.getStalkSuffix(i);
            builder.texture("stalk" + suffix, top ? EnvironmentalBlockStateProvider.suffix((ResourceLocation)texture, (String)suffix) : texture);
        }
        return builder;
    }

    public static String getStalkSuffix(int stalks) {
        return stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
    }

    public ModelFile cattailHeadModel(String name, ResourceLocation texture, boolean top, int stalks) {
        String stalkSuffix = stalks == 3 ? "_three" : (stalks == 2 ? "_two" : "_one");
        ModelFile.UncheckedModelFile cattailParent = new ModelFile.UncheckedModelFile(Environmental.location("block/template_" + (top ? "cattail_top" : "cattail") + stalkSuffix));
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + (top ? "_top" : "") + stalkSuffix)).parent((ModelFile)cattailParent)).texture("cattail", texture);
    }

    public void cactusBobble(RegistryObject<Block> cactusBobble) {
        this.simpleBlock((Block)cactusBobble.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(EnvironmentalBlockStateProvider.name((Block)((Block)cactusBobble.get())))).parent((ModelFile)new ModelFile.UncheckedModelFile(Environmental.location("block/template_cactus_bobble")))).texture("all", this.blockTexture((Block)cactusBobble.get())));
    }
}

