/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="environmental")
public class EnvironmentalConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue deerFlowerReproducing;
        public final ForgeConfigSpec.DoubleValue deerAntlerChance;
        public final ForgeConfigSpec.BooleanValue blockOnlyNaturalSpawns;
        public final ForgeConfigSpec.IntValue koiHorizontalSerenityRange;
        public final ForgeConfigSpec.IntValue koiVerticalSerenityRange;
        public final ForgeConfigSpec.BooleanValue serenityEffect;
        public final ForgeConfigSpec.BooleanValue largerPigLitters;
        public final ForgeConfigSpec.IntValue minimumAdditionalPiglets;
        public final ForgeConfigSpec.IntValue maximumAdditionalPiglets;
        public final ForgeConfigSpec.BooleanValue largerHoglinLitters;
        public final ForgeConfigSpec.IntValue minimumAdditionalHoglets;
        public final ForgeConfigSpec.IntValue maximumAdditionalHoglets;
        public final ForgeConfigSpec.BooleanValue muddyPigs;
        public final ForgeConfigSpec.BooleanValue naturalMuddyPigs;
        public final ForgeConfigSpec.DoubleValue muddyPigDecorationChance;
        public final ForgeConfigSpec.BooleanValue decoratableMuddyPigs;
        public final ForgeConfigSpec.BooleanValue muddyPigsGetWetInWater;
        public final ForgeConfigSpec.BooleanValue muddyPigsGetWetInRain;
        public final ForgeConfigSpec.BooleanValue muddyPigsDryOverTime;
        public final ForgeConfigSpec.BooleanValue muddyPigsOnlyDryInTheNether;
        public final ForgeConfigSpec.BooleanValue pigsHuntTruffles;
        public final ForgeConfigSpec.BooleanValue cactusBobble;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("deer");
            this.deerFlowerReproducing = builder.comment("If Deer can reproduce and spread flowers by feeding them an Apple followed by a flower").define("Deer flower reproducing", true);
            this.deerAntlerChance = builder.comment("The chance Deer have to spawn with Antlers; 0.0 for never, 1.0 for always").defineInRange("Deer Antler chance", 0.5, 0.0, 1.0);
            builder.pop();
            builder.push("koi");
            this.blockOnlyNaturalSpawns = builder.comment("Make Koi only block natural spawns").define("Block only natural spawns", true);
            this.koiHorizontalSerenityRange = builder.comment("Horizontal radius of Serenity effect in blocks").defineInRange("Horizontal serenity range (radius)", 32, 0, Integer.MAX_VALUE);
            this.koiVerticalSerenityRange = builder.comment("Vertical radius of Serenity effect in blocks").defineInRange("Vertical serenity range (radius)", 8, 0, Integer.MAX_VALUE);
            this.serenityEffect = builder.comment("If Koi exude Serenity as a potion effect").define("Serenity potion effect", true);
            builder.pop();
            builder.push("pig");
            this.pigsHuntTruffles = builder.comment("If Pigs hunt for Truffles when given a Golden Carrot").define("Pigs hunt Truffles", true);
            this.largerPigLitters = builder.comment("If Pigs should spawn more Piglets upon breeding").define("Larger Pig litters", true);
            builder.push("larger_litters");
            this.minimumAdditionalPiglets = builder.comment("The minimum amount of piglets that can spawn in addition to the original child").defineInRange("Minimum additional piglets", 1, 0, Integer.MAX_VALUE);
            this.maximumAdditionalPiglets = builder.comment("The maximum amount of piglets that can spawn in addition to the original child").defineInRange("Maximum additional piglets", 3, 0, Integer.MAX_VALUE);
            builder.pop();
            this.muddyPigs = builder.comment("If Pigs can be made muddy by walking in Mud or being hit with Mud Balls").define("Muddy Pigs", true);
            builder.push("muddy_pigs");
            this.naturalMuddyPigs = builder.comment("If Pigs naturally spawn muddy in swampy biomes").define("Natural Muddy Pigs", true);
            this.muddyPigDecorationChance = builder.comment("The chance that a Muddy Pig has to spawn with a decoration, such as a flower").defineInRange("Muddy Pig decoration chance", 0.2, 0.0, 1.0);
            this.decoratableMuddyPigs = builder.comment("If Muddy Pigs can be decorated with various flowers, saplings, and plants").define("Decoratable Muddy Pigs", true);
            this.muddyPigsDryOverTime = builder.comment("If Muddy Pigs become dry naturally over time").define("Muddy Pigs dry over time", true);
            this.muddyPigsOnlyDryInTheNether = builder.comment("If Muddy Pigs only naturally dry when in the Nether").define("Muddy Pigs only dry in the Nether", false);
            this.muddyPigsGetWetInWater = builder.comment("If dry Muddy Pigs should become wet again when in water").define("Muddy Pigs get wet in water", true);
            this.muddyPigsGetWetInRain = builder.comment("If dry Muddy Pigs should become wet again when in rain").define("Muddy Pigs get wet in rain", true);
            builder.pop();
            builder.pop();
            builder.push("hoglin");
            this.largerHoglinLitters = builder.comment("If Hoglins should spawn more babies upon breeding").define("Larger Hoglin litters", true);
            builder.push("larger_litters");
            this.minimumAdditionalHoglets = builder.comment("The minimum amount of baby hoglins that can spawn in addition to the original child").defineInRange("Minimum additional babies", 1, 0, Integer.MAX_VALUE);
            this.maximumAdditionalHoglets = builder.comment("The maximum amount of baby hoglins that can spawn in addition to the original child").defineInRange("Maximum additional babies", 2, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.pop();
            builder.push("blocks");
            this.cactusBobble = builder.comment("Cacti generate with a Cactus Bobble on top to prevent natural growth").define("Cactus bobble", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue babyChickenTexture;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("mobs");
            builder.push("chicken");
            this.babyChickenTexture = builder.comment("If Chickens have a different texture when they are babies").define("Baby chicken texture", true);
            builder.pop();
            builder.pop();
        }
    }
}

