/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CoarseDirtOnStoneFeature
extends Feature<NoneFeatureConfiguration> {
    public CoarseDirtOnStoneFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int j;
        int i;
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos pos = context.m_159777_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double radius = this.getRadius(random);
        int intradius = Mth.m_14165_((double)radius);
        double xoffset = random.m_188500_() - 0.5;
        double yoffset = random.m_188500_() - 0.5;
        int diameter = 2 * intradius;
        int[][] heights = new int[diameter + 1][diameter + 1];
        for (i = 0; i <= diameter; ++i) {
            for (j = 0; j <= diameter; ++j) {
                int x = i - intradius + pos.m_123341_();
                int z = j - intradius + pos.m_123343_();
                heights[i][j] = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
            }
        }
        for (i = 0; i <= diameter; ++i) {
            for (j = 0; j <= diameter; ++j) {
                int maxy;
                int a = i - intradius;
                int b = j - intradius;
                int x = a + pos.m_123341_();
                int z = b + pos.m_123343_();
                int miny = maxy = heights[i][j] - 1;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    int x1 = i + direction.m_122429_();
                    int z1 = j + direction.m_122431_();
                    if (x1 < 0 || x1 > diameter || z1 < 0 || z1 > diameter) continue;
                    miny = Math.min(miny, heights[x1][z1]);
                }
                for (int y = maxy; y >= miny; --y) {
                    double d = Math.pow((double)a - xoffset, 2.0) + Math.pow(y - pos.m_123342_() + 1, 2.0) + Math.pow((double)b - yoffset, 2.0);
                    if (!(d <= radius * radius)) continue;
                    mutable.m_122178_(x, y, z);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (!state.m_204336_(BlockTags.f_13061_)) continue;
                    level.m_7731_((BlockPos)mutable, Blocks.f_50546_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    protected double getRadius(RandomSource random) {
        return Math.pow(random.m_188500_(), 2.0) + 1.5;
    }
}

