/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.common.entity.animal.zebroid;

import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebraFleeGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidAttackGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidHurtByTargetGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidRandomStandGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidRunAroundLikeCrazyGoal;
import com.teamabnormals.environmental.common.entity.ai.goal.zebroid.ZebroidTemptGoal;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zebroid;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractUnchestedZebroid
extends AbstractHorse
implements NeutralMob,
Zebroid {
    private static final EntityDataAccessor<Integer> KICK_TIME = SynchedEntityData.m_135353_(AbstractUnchestedZebroid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> ANGRY_AT = SynchedEntityData.m_135353_(AbstractUnchestedZebroid.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)16, (int)32);
    private int remainingPersistentAngerTime;
    private ZebraFleeGoal fleeGoal;
    private float jumpStrength = -1.0f;
    private int kickCounter = 20;
    private float backKickAnim;
    private float backKickAnimO;
    private float frontKickAnim;
    private float frontKickAnimO;

    public AbstractUnchestedZebroid(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new ZebroidAttackGoal<AbstractUnchestedZebroid>(this, 1.6));
        this.f_21345_.m_25352_(3, new ZebroidRunAroundLikeCrazyGoal<AbstractUnchestedZebroid>(this, 1.6));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0, AbstractHorse.class));
        this.f_21345_.m_25352_(5, new ZebroidTemptGoal<AbstractUnchestedZebroid>(this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_, Items.f_42436_, Items.f_42437_})));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(11, new ZebroidRandomStandGoal<AbstractUnchestedZebroid>(this));
        this.f_21346_.m_25352_(1, new ZebroidHurtByTargetGoal<AbstractUnchestedZebroid>(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractUnchestedZebroid)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.m_7509_();
    }

    protected void m_7509_() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KICK_TIME, (Object)0);
        this.f_19804_.m_135372_(ANGRY_AT, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_147285_(this.m_9236_(), compound);
    }

    @Override
    public void setKickTime(int time) {
        this.f_19804_.m_135381_(KICK_TIME, (Object)time);
    }

    @Override
    public int getKickTime() {
        return (Integer)this.f_19804_.m_135370_(KICK_TIME);
    }

    @Override
    public boolean canJumpKick() {
        return this.jumpStrength >= 0.0f;
    }

    @Override
    public void setJumpStrength(float strength) {
        this.jumpStrength = strength;
    }

    @Override
    public float getJumpStrength() {
        return this.jumpStrength;
    }

    @Override
    public boolean isFleeing() {
        return false;
    }

    @Override
    public void setGallopSoundCounter(int count) {
        this.f_30524_ = count;
    }

    @Override
    public int getGallopSoundCounter() {
        return this.f_30524_;
    }

    @Override
    public boolean canGallop() {
        return this.f_30523_;
    }

    @Override
    public void setKickCounter(int count) {
        this.kickCounter = count;
    }

    @Override
    public int getKickCounter() {
        return this.kickCounter;
    }

    @Override
    public void setBackKickAnim(float amount) {
        this.backKickAnim = amount;
    }

    @Override
    public float getBackKickAnim() {
        return this.backKickAnim;
    }

    @Override
    public void setBackKickAnimO(float amount) {
        this.backKickAnimO = amount;
    }

    @Override
    public float getBackKickAnimO() {
        return this.backKickAnimO;
    }

    @Override
    public void setFrontKickAnim(float amount) {
        this.frontKickAnim = amount;
    }

    @Override
    public float getFrontKickAnim() {
        return this.frontKickAnim;
    }

    @Override
    public void setFrontKickAnimO(float amount) {
        this.frontKickAnimO = amount;
    }

    @Override
    public float getFrontKickAnimO() {
        return this.frontKickAnimO;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack;
        boolean flag;
        boolean bl = flag = !this.m_6162_() && this.m_30614_() && player.m_36341_();
        if (!(this.m_20160_() || flag || player.m_21120_(hand).m_41619_() || this.m_30614_())) {
            if (this.m_21674_((LivingEntity)player)) {
                return InteractionResult.CONSUME;
            }
            this.m_7564_();
            this.m_6710_((LivingEntity)player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_20160_() && !flag && !(itemstack = player.m_21120_(hand)).m_41619_() && this.m_6898_(itemstack)) {
            return this.m_30580_(player, itemstack);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        this.handleTick();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_7023_(Vec3 motion) {
        boolean flag = this.m_30616_();
        super.m_7023_(motion);
        this.handleTravel(flag);
    }

    public void m_21463_(Entity entity, boolean broadcast) {
        super.m_21463_(entity, broadcast);
        this.handleLeashed(entity);
    }

    public boolean m_7559_() {
        return this.canDoIdleAnimation();
    }

    public boolean m_6779_(LivingEntity target) {
        return (!this.m_30614_() || !(target instanceof Player)) && super.m_6779_(target);
    }

    public void m_21662_() {
        super.m_21662_();
        this.m_6598_(null);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int time) {
        this.remainingPersistentAngerTime = time;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID target) {
        this.f_19804_.m_135381_(ANGRY_AT, Optional.ofNullable(target));
    }

    public UUID m_6120_() {
        return ((Optional)this.f_19804_.m_135370_(ANGRY_AT)).orElse(null);
    }

    @Override
    public void playKickingSound() {
        this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
    }

    @Override
    public void playAngrySound() {
        this.m_5496_(this.m_7871_(), this.m_6121_(), this.m_6100_());
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.handleStepSound(pos, state);
    }

    @Override
    public void playZebroidGallopSound(SoundType soundType) {
        this.m_5877_(soundType);
    }

    public void m_19956_(Entity rider, Entity.MoveFunction function) {
        super.m_19956_(rider, function);
        this.handlePositionRider(rider, function);
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.playFrontKickAnim();
        } else if (id == 9) {
            this.playBackKickAnim();
        } else {
            super.m_7822_(id);
        }
    }
}

