/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.client.model.ZorseModel;
import com.teamabnormals.environmental.common.entity.animal.zebroid.Zorse;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZorseMarkingsLayer
extends RenderLayer<Zorse, ZorseModel<Zorse>> {
    private static final Map<Markings, ResourceLocation> LOCATION_BY_MARKINGS = (Map)Util.m_137469_((Object)Maps.newEnumMap(Markings.class), map -> {
        map.put(Markings.NONE, null);
        map.put(Markings.WHITE, new ResourceLocation("textures/entity/horse/horse_markings_white.png"));
        map.put(Markings.WHITE_FIELD, new ResourceLocation("textures/entity/horse/horse_markings_whitefield.png"));
        map.put(Markings.WHITE_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_whitedots.png"));
        map.put(Markings.BLACK_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_blackdots.png"));
    });

    public ZorseMarkingsLayer(RenderLayerParent<Zorse, ZorseModel<Zorse>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Zorse zorse, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation resourcelocation = LOCATION_BY_MARKINGS.get(zorse.getMarkings());
        if (resourcelocation != null && !zorse.m_20145_()) {
            VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)resourcelocation));
            ((ZorseModel)this.m_117386_()).m_7695_(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)zorse, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

