/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.environmental.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.environmental.core.other.EnvironmentalModelLayers;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;

@OnlyIn(value=Dist.CLIENT)
public class MuleArmorLayer<T extends AbstractChestedHorse>
extends RenderLayer<T, ChestedHorseModel<T>> {
    private final HorseModel<T> model;

    public MuleArmorLayer(RenderLayerParent<T, ChestedHorseModel<T>> entityRenderer, EntityModelSet modelSet) {
        super(entityRenderer);
        this.model = new ChestedHorseModel(modelSet.m_171103_(EnvironmentalModelLayers.MULE_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T mule, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(mule instanceof Mule)) {
            return;
        }
        ItemStack itemstack = mule.m_6844_(EquipmentSlot.CHEST);
        if (itemstack.m_41720_() instanceof HorseArmorItem) {
            float f2;
            float f1;
            float f;
            HorseArmorItem horsearmoritem = (HorseArmorItem)itemstack.m_41720_();
            ((ChestedHorseModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_(mule, limbSwing, limbSwingAmount, partialTick);
            this.model.m_6973_(mule, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (horsearmoritem instanceof DyeableHorseArmorItem) {
                int i = ((DyeableHorseArmorItem)horsearmoritem).m_41121_(itemstack);
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            ItemStack stack = mule.m_6844_(EquipmentSlot.CHEST);
            MuleArmorLayer.setColorRuneTarget(stack);
            HorseArmorItem horseArmorItem = (HorseArmorItem)stack.m_41720_();
            VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)horseArmorItem.m_41367_()), (boolean)false, (boolean)stack.m_41790_());
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f);
        }
    }

    private static void setColorRuneTarget(ItemStack stack) {
        if (ModList.get().isLoaded("quark")) {
            ColorRunesModule.setTargetStack((ItemStack)stack);
        }
    }
}

