/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.util;

import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.util.TargetMode;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityUtil {
    public static final String THRALL_KEY = "eidolon:thrall";
    private static final Predicate<Entity> FALLBACK_TARGET_PREDICATE = entity -> true;

    public static void enthrall(LivingEntity caster, LivingEntity thrall) {
        thrall.getPersistentData().m_128362_(THRALL_KEY, caster.m_20148_());
        if (thrall instanceof Mob) {
            Mob mob = (Mob)thrall;
            mob.m_21530_();
        }
    }

    public static boolean isEnthralled(LivingEntity entity) {
        return entity.getPersistentData().m_128441_(THRALL_KEY);
    }

    public static boolean isEnthralledBy(LivingEntity entity, LivingEntity owner) {
        return entity != null && owner != null && EntityUtil.isEnthralled(entity) && entity.getPersistentData().m_128342_(THRALL_KEY).equals(owner.m_20148_());
    }

    public static boolean sameMaster(@NotNull LivingEntity entity, @NotNull LivingEntity source) {
        if (!EntityUtil.isEnthralled(entity) || !EntityUtil.isEnthralled(source)) {
            return false;
        }
        return entity.getPersistentData().m_128342_(THRALL_KEY).equals(source.getPersistentData().m_128342_(THRALL_KEY));
    }

    public static void moveTowardsTarget(Entity entity) {
        Predicate<Entity> targetPredicate;
        Entity owner;
        if (entity == null) {
            return;
        }
        if (entity instanceof Projectile) {
            Predicate<Entity> targetMode;
            Projectile projectile = (Projectile)entity;
            owner = projectile.m_19749_();
            if (projectile instanceof TargetMode) {
                TargetMode mode = (TargetMode)projectile;
                v0 = mode.eidolonrepraised$getMode();
            } else {
                v0 = targetMode = null;
            }
            if (entity instanceof SpellProjectileEntity) {
                SpellProjectileEntity spellProjectile = (SpellProjectileEntity)entity;
                targetPredicate = spellProjectile.compulsoryTrackingPredicate.or(targetMode != null ? targetMode : target -> false).and(spellProjectile.trackingPredicate);
            } else {
                targetPredicate = targetMode != null ? targetMode : FALLBACK_TARGET_PREDICATE;
            }
        } else {
            owner = null;
            targetPredicate = FALLBACK_TARGET_PREDICATE;
        }
        List entities = entity.f_19853_.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(12.0), target -> !(!targetPredicate.test((Entity)target) || target == owner || !target.m_6084_() || owner != null && target.m_7307_(owner) || entity.f_19853_.m_5776_() && target == Minecraft.m_91087_().f_91074_));
        if (!entities.isEmpty()) {
            LivingEntity nearest = entities.stream().min(Comparator.comparingDouble(e -> e.m_20280_(entity))).get();
            Vec3 diff = nearest.m_20182_().m_82520_(0.0, (double)(nearest.m_20206_() / 2.0f), 0.0).m_82546_(entity.m_20182_());
            Vec3 newmotion = entity.m_20184_().m_82549_(diff.m_82541_()).m_82490_(0.75);
            entity.m_20256_(newmotion);
        }
    }
}

