/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.api.spells.Spell;
import elucent.eidolon.common.spell.ExecCommandSpell;
import elucent.eidolon.recipe.ChantRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandChantRecipe
extends ChantRecipe {
    List<String> commands;
    int manaCost = 0;

    public CommandChantRecipe(ResourceLocation id, List<Sign> signs, List<String> commands, int manaCost) {
        super(id, signs);
        this.commands = commands;
        this.manaCost = manaCost;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    @Override
    public Spell getChant() {
        return new ExecCommandSpell(this.id, this.manaCost, this.signs(), this.getCommands());
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.COMMAND_CHANT_TYPE.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.COMMAND_CHANT_SERIALIZER.get();
    }

    @Override
    public JsonObject toJson() {
        JsonObject base = super.toJson();
        JsonArray commandsJson = new JsonArray();
        for (String command : this.commands) {
            commandsJson.add(command);
        }
        base.add("commands", (JsonElement)commandsJson);
        base.addProperty("mana_cost", (Number)this.manaCost);
        return base;
    }

    public static class Serializer
    implements RecipeSerializer<CommandChantRecipe> {
        @NotNull
        public CommandChantRecipe fromJson(@NotNull ResourceLocation resourceLocation, @NotNull JsonObject jsonObject) {
            JsonArray signsArray = jsonObject.getAsJsonArray("signs");
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (JsonElement sign : signsArray) {
                signs.add(Signs.find(new ResourceLocation(sign.getAsString())));
            }
            JsonArray commandsArray = jsonObject.getAsJsonArray("commands");
            ArrayList<String> commands = new ArrayList<String>();
            for (JsonElement command : commandsArray) {
                commands.add(command.getAsString());
            }
            int manaCost = jsonObject.has("mana_cost") ? jsonObject.get("mana_cost").getAsInt() : 0;
            return new CommandChantRecipe(resourceLocation, signs, commands, manaCost);
        }

        @Nullable
        public CommandChantRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, @NotNull FriendlyByteBuf friendlyByteBuf) {
            int n = friendlyByteBuf.readInt();
            ArrayList<Sign> signs = new ArrayList<Sign>();
            for (int i = 0; i < n; ++i) {
                signs.add(Signs.find(friendlyByteBuf.m_130281_()));
            }
            int commandCount = friendlyByteBuf.readInt();
            ArrayList<String> commands = new ArrayList<String>();
            for (int i = 0; i < commandCount; ++i) {
                commands.add(friendlyByteBuf.m_130277_());
            }
            int manaCost = friendlyByteBuf.readInt();
            return new CommandChantRecipe(resourceLocation, signs, commands, manaCost);
        }

        public void toNetwork(@NotNull FriendlyByteBuf friendlyByteBuf, @NotNull CommandChantRecipe chantRecipe) {
            friendlyByteBuf.writeInt(chantRecipe.signs.size());
            for (Sign sign : chantRecipe.signs) {
                friendlyByteBuf.m_130085_(sign.getRegistryName());
            }
            friendlyByteBuf.writeInt(chantRecipe.commands.size());
            for (String command : chantRecipe.commands) {
                friendlyByteBuf.m_130070_(command);
            }
            friendlyByteBuf.writeInt(chantRecipe.manaCost);
        }
    }
}

