/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.mixin;

import elucent.eidolon.Eidolon;
import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.util.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="TAIL")}, cancellable=true)
    public void eidolonrepraised$canAttack(LivingEntity pTarget, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (pTarget != null && EntityUtil.isEnthralled(living)) {
                if (living.m_7307_((Entity)pTarget)) {
                    cir.setReturnValue((Object)false);
                }
                UUID master = living.getPersistentData().m_128342_("eidolon:thrall");
                Player player = living.m_9236_().m_46003_(master);
                if (player instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)player;
                    LivingEntity lastHurt = player2.m_21214_();
                    LivingEntity lastHurtBy = player2.m_21188_();
                    if (lastHurt != pTarget && lastHurtBy != pTarget) {
                        cir.setReturnValue((Object)false);
                    }
                }
            }
        }
    }

    @Inject(method={"getMobType"}, at={@At(value="HEAD")}, cancellable=true)
    public void eidolonrepraised$getMobType(CallbackInfoReturnable<MobType> ci) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21221_() != null && living.m_21023_((MobEffect)EidolonPotions.UNDEATH_EFFECT.get()) && !Eidolon.trueMobType) {
            ci.setReturnValue((Object)MobType.f_21641_);
        }
    }

    @Inject(method={"isFallFlying"}, at={@At(value="HEAD")}, cancellable=true)
    public void eidolonrepraised$isFallFlying(CallbackInfoReturnable<Boolean> ci) {
        Player p;
        Optional opt;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (opt = (p = (Player)livingEntity).getCapability(IPlayerData.INSTANCE).resolve()).isPresent() && ((IPlayerData)opt.get()).isDashing(p)) {
            ci.setReturnValue((Object)true);
        }
    }
}

