/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.capability;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ReputationCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"devotion").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"deity", (ArgumentType)new DeityArgument()).executes(ctx -> ReputationCommand.applyGet((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> sources.m_81372_().getCapability(IReputation.INSTANCE).ifPresent(k -> {
            double devotion = k.getReputation((Player)player, DeityArgument.getDeity(ctx, "deity").getId());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " : " + devotion)), false);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"deity", (ArgumentType)new DeityArgument()).then(Commands.m_82129_((String)"qt", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(ctx -> ReputationCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> sources.m_81372_().getCapability(IReputation.INSTANCE).ifPresent(k -> k.setReputation((Player)player, DeityArgument.getDeity(ctx, "deity").getId(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"qt"))))))))).then(Commands.m_82127_((String)"tryfix").executes(ctx -> ReputationCommand.apply((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), (player, sources) -> player.getCapability(IKnowledge.INSTANCE).ifPresent(k -> KnowledgeUtil.tryFix(player)))))));
    }

    private static int apply(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        if (players.size() == 1) {
            sources.m_288197_(() -> Component.m_237110_((String)"commands.eidolon.reputation.success.single", (Object[])new Object[]{((Player)players.iterator().next()).m_5446_()}), true);
        } else {
            sources.m_288197_(() -> Component.m_237110_((String)"commands.eidolon.reputation.success.multiple", (Object[])new Object[]{players.size()}), true);
        }
        return players.size();
    }

    private static int applyGet(CommandSourceStack sources, Collection<? extends Player> players, BiConsumer<Player, CommandSourceStack> action) {
        for (Player player : players) {
            action.accept(player, sources);
        }
        return players.size();
    }

    public static class DeityArgument
    implements ArgumentType<Deity> {
        private static final DynamicCommandExceptionType UNKNOWN = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"argument.eidolon.deity.unknown", (Object[])new Object[]{obj}));

        public static Deity getDeity(CommandContext<?> context, String name) {
            return (Deity)context.getArgument(name, Deity.class);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (Deity s : Deities.getDeities()) {
                if (!s.getId().toString().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(s.getId().toString());
            }
            return builder.buildFuture();
        }

        public Deity parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation rl = ResourceLocation.m_135818_((StringReader)reader);
            Deity s = Deities.find(rl);
            if (s == null) {
                throw UNKNOWN.create((Object)rl.toString());
            }
            return s;
        }

        public static DeityArgument deities() {
            return new DeityArgument();
        }
    }
}

