/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.option;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceNamedTextFieldWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceTextFieldWidget;

public class SpruceDoubleInputOption
extends SpruceOption {
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;

    public SpruceDoubleInputOption(String key, Supplier<Double> getter, Consumer<Double> setter, @Nullable Component tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.DOUBLE_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Double.parseDouble(textField.getText());
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_);
            }
            catch (NumberFormatException e) {
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_.m_131140_(ChatFormatting.RED));
            }
        });
        textField.setChangedListener(input -> {
            double value;
            try {
                value = Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            this.set(value);
        });
        this.getOptionTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter.get();
    }
}

