/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Pets;

import java.util.List;
import java.util.function.DoubleSupplier;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Effect.CameraShakeEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.SkeletosaurusEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.ShockwaveEntity;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.IAnimatedTamableMob;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ILookingTamableMobStateGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobStateGoal;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class SkeloraptorEntity
extends IAnimatedTamableMob
implements PlayerRideableJumping {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SkeloraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(SkeloraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(SkeloraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SCARY_COOLDOWN = SynchedEntityData.m_135353_(SkeloraptorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int cooldown = 0;
    private static final int COOLDOWN_DURATION = 40;
    private static final float MAX_ROTATION = 0.0f;
    private static final float ROTATION_SPEED = 0.2f;
    private int walkAnimationTickCounter = 0;
    private static final int MESSAGE_INTERVAL = 15;
    public final int ROAR_COOLDOWN = 300;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private float prevYaw;
    private int regenerationCooldown = 30;
    public int roarCooldown = 300;
    private double lastY = 0.0;
    private boolean reduceFallDamage = false;
    public AnimationState sitidleAnimationState = new AnimationState();
    public AnimationState sitstartAnimationState = new AnimationState();
    public AnimationState sitendAnimationState = new AnimationState();
    public AnimationState sleepAnimationState = new AnimationState();
    public AnimationState tailAnimationState = new AnimationState();
    public AnimationState tailmAnimationState = new AnimationState();
    public AnimationState awakeAnimationState = new AnimationState();
    public AnimationState biteAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState shockwaveAnimationState = new AnimationState();
    public AnimationState stompsAnimationState = new AnimationState();
    protected int gallopSoundCounter;
    protected boolean canGallop = true;
    private double lastJumpHeight = 0.0;
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    protected boolean allowStandSliding;
    private int standCounter;

    public SkeloraptorEntity(EntityType<? extends IAnimatedTamableMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_21530_();
        this.m_274367_(1.5f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
    }

    public boolean canTravel() {
        return this.getAttackState() == 0 && !this.isSitting();
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    public void m_8119_() {
        LivingEntity forward2;
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (this.getAttackState() == 0 && ((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue() && this.getAttackState() != 6) {
            this.setAttackState(6);
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.f_19797_ % 10 == 0 && (livingEntity = this.m_6688_()) instanceof Player) {
            player = (Player)livingEntity;
            if (this.roarCooldown > 0) {
                this.sendActionBarMessage(player);
            }
        }
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            return;
        }
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0 && !this.isSitting(), this.f_19797_);
        }
        this.UpdateWithAttack();
        if (!this.m_9236_().f_46443_ && this.f_19797_ % this.regenerationCooldown == 0 && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            player = (Player)livingEntity;
            if (this.m_20186_() < this.lastJumpHeight && !this.m_20096_()) {
                this.reduceFallDamage = true;
            }
        }
        if (this.m_20096_()) {
            this.reduceFallDamage = false;
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            player = (Player)livingEntity;
            this.f_19859_ = player.f_19859_;
            this.f_19859_ = player.f_19859_;
            this.m_146922_(this.f_19859_);
            this.m_5618_(this.f_19859_);
            float forward2 = player.f_20902_;
            float strafe = player.f_20900_;
            if (this.m_20160_() && this.m_6688_() instanceof Player) {
                this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_() + 0.1f);
            } else {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.05);
            }
            if (this.canTravel()) {
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward2));
            }
        }
        this.handleWalkingMessage();
        if (this.m_20160_() && (forward2 = this.m_6688_()) instanceof Player) {
            player = (Player)forward2;
            if (!this.m_20096_()) {
                double fallDistance = this.lastY - this.m_20186_();
                this.reduceFallDamage = fallDistance < 10.0 && fallDistance > 0.0;
            }
        }
        if (this.m_20096_()) {
            this.reduceFallDamage = false;
        }
        this.lastY = this.m_20186_();
    }

    private void handleWalkingMessage() {
        if (this.isMoving()) {
            ++this.walkAnimationTickCounter;
            if (this.walkAnimationTickCounter >= 15) {
                this.walkAnimationTickCounter = 0;
                Vec3 vec3 = this.m_20182_();
            }
        } else {
            this.walkAnimationTickCounter = 0;
        }
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    private void sendMessageToAllPlayers(String message) {
        this.m_9236_().m_6907_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_213846_((Component)Component.m_237113_((String)message));
            }
        });
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        if (this.reduceFallDamage && fallDistance < 60.0f) {
            return false;
        }
        return super.m_142535_(fallDistance, damageMultiplier, source);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    private void sendActionBarMessage(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237115_((String)"legendary_monsters.message.skeloraptor_time_until_next_roar").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.roarCooldown / 10)));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private void sendActionBarMessageToPlayer(Player player, String translationKey, String entityName) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)entityName)).m_130946_(">").m_7220_((Component)Component.m_237115_((String)translationKey));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private void sendMountBarMessage(Player player, String translationKey) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237115_((String)translationKey);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    private String getEntityName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return "legendary_monsters.message.skeloraptor_string_message_name";
    }

    @Override
    public double baseHealth() {
        return 60.0;
    }

    @Override
    public double baseDamage() {
        return 10.0;
    }

    @Override
    public double healthMult() {
        return (Double)ModConfig.MOB_CONFIG.SkeloraptorHealthMutliplier.get();
    }

    @Override
    public double damageMult() {
        return (Double)ModConfig.MOB_CONFIG.SkeloraptorDamageMultiplier.get();
    }

    public void m_21839_(boolean sitting) {
        super.m_21839_(sitting);
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        if (sitting) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_sit_enable", this.getEntityName());
            }
        } else {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setAttackState(0);
                this.m_21573_().m_26569_();
                this.stopAllAnimationStates();
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_walk_enable", this.getEntityName());
            }
            this.m_21573_().m_26573_();
            this.m_21557_(false);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SCARY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    private void launch(LivingEntity entity, boolean huge) {
        double deltaX = entity.m_20185_() - this.m_20185_();
        double deltaZ = entity.m_20189_() - this.m_20189_();
        double distanceSquared = Math.max(deltaX * deltaX + deltaZ * deltaZ, 1.0E-4);
        float multiplier = huge ? 1.2f : 0.5f;
        entity.m_5997_(deltaX / distanceSquared * (double)multiplier, huge ? 0.5 : 0.2, deltaZ / distanceSquared * (double)multiplier);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean stun, float knockback, boolean BNknockback, float Lstrenght, boolean launch) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof SkeletosaurusEntity || entityHit == this) continue;
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * this.damageMult()));
            if (launch) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK.get(), 2.0f, 1.0f);
                this.launch(entityHit, true);
            }
            if (!(entityHit instanceof Player) || !entityHit.m_21254_() || shieldbreakticks <= 0) continue;
            SkeloraptorEntity.disableShield(entityHit, shieldbreakticks);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private void runawayMobs() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 10.0, 16.0));
        for (LivingEntity e : list) {
            Vec3 vec;
            PathfinderMob mob;
            if (this.m_7307_((Entity)e) || !(e instanceof PathfinderMob) || (mob = (PathfinderMob)e) instanceof TamableAnimal && ((TamableAnimal)mob).m_21825_()) continue;
            mob.m_6710_(null);
            mob.m_6703_(null);
            if (mob.m_20096_()) {
                Vec3 randomShake = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), 0.0, (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.1f);
                mob.m_20256_(mob.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
            }
            mob.m_21573_().m_26573_();
            if (!mob.m_21573_().m_26571_() || (vec = LandRandomPos.m_148521_((PathfinderMob)mob, (int)15, (int)7, (Vec3)this.m_20182_())) == null) continue;
            mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
        }
    }

    public void UpdateWithAttack() {
        if (this.getAttackState() == 1) {
            if (this.attackTicks > 5 && this.attackTicks < 20) {
                this.runawayMobs();
            }
            if (this.attackTicks == 1) {
                this.m_5496_((SoundEvent)ModSounds.ANCIENT_GUARDIAN_ROAR.get(), 4.0f, 0.75f);
            }
            if (this.attackTicks == 6) {
                // empty if block
            }
        }
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 7) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SPIN.get(), 2.0f, 1.0f);
            }
            if (this.attackTicks == 16) {
                this.AreaAttack(5.0f, 3.0f, 180.0f, 10.0f, 40, false, 0.0f, false, 0.75f, true);
            }
        }
        if (this.getAttackState() == 4) {
            int k;
            float f2;
            int k2;
            int standingOnY;
            Vec3 entityPoesition;
            if (this.attackTicks == 12) {
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                this.AreaAttack(2.0f, 3.0f, 360.0f, 7.0f, 40, false, 0.0f, false, 0.75f, false);
                this.SpawnCircleParticle(0.25f, -0.5f, 10.0f, true, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                entityPoesition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k2 = 0; k2 < 6; ++k2) {
                    f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                }
            }
            if (this.attackTicks == 13) {
                int standingOnY2 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY2, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 16) {
                int standingOnY3 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY3, this.m_20186_() + 1.0, f4, 0);
                }
            }
            if (this.attackTicks == 37) {
                this.AreaAttack(2.0f, 3.0f, 360.0f, 7.0f, 40, false, 0.0f, false, 0.75f, false);
                this.SpawnCircleParticle(0.25f, -0.5f, 10.0f, true, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
                entityPoesition = this.m_20182_();
                CameraShakeEntity.cameraShake(this.m_9236_(), entityPoesition, 20.0f, 0.05f, 0, 20);
                standingOnY = Mth.m_14107_((double)this.m_20186_());
                for (k2 = 0; k2 < 6; ++k2) {
                    f2 = (float)k2 * (float)Math.PI * 2.0f / 6.0f + 1.2566371f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, standingOnY, this.m_20186_() + 1.0, f2, 0);
                }
            }
            if (this.attackTicks == 40) {
                int standingOnY4 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 11; ++k) {
                    float f3 = (float)k * (float)Math.PI * 2.0f / 11.0f + 0.62831855f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f3) * 3.5, this.m_20189_() + (double)Mth.m_14031_((float)f3) * 3.5, standingOnY4, this.m_20186_() + 1.0, f3, 0);
                }
            }
            if (this.attackTicks == 43) {
                int standingOnY5 = Mth.m_14107_((double)this.m_20186_());
                for (k = 0; k < 14; ++k) {
                    float f4 = (float)k * (float)Math.PI * 2.0f / 14.0f + 0.31415927f;
                    this.spawnShockwaves(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 4.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 4.5, standingOnY5, this.m_20186_() + 1.0, f4, 0);
                }
            }
        }
    }

    private void spawnShockwaves(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos((int)x, (int)maxY, (int)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            SkeloraptorEntity entity1 = this;
            this.m_9236_().m_7967_((Entity)new ShockwaveEntity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (LivingEntity)entity1, false, 4.0f));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.m_21827_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_21839_(compound.m_128471_("Sitting"));
        if (this.m_21223_() == this.m_21233_()) {
            // empty if block
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 4, 0, 55, 55, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeloraptorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && SkeloraptorEntity.this.m_5448_() != null && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false && SkeloraptorEntity.this.m_6688_() == null;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 3, 0, 50, 55, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeloraptorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && SkeloraptorEntity.this.m_5448_() != null && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false && SkeloraptorEntity.this.m_6688_() == null;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 1, 0, 53, 55, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && SkeloraptorEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && SkeloraptorEntity.this.m_5448_() != null && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false && SkeloraptorEntity.this.roarCooldown <= 0 && SkeloraptorEntity.this.m_6688_() == null;
            }

            @Override
            public void m_8041_() {
                SkeloraptorEntity.this.roarCooldown = 300;
                super.m_8041_();
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)SkeloraptorEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 1, 1, 0, 53, 53){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 4, 4, 0, 55, 55){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 3, 3, 0, 50, 50){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 7, 7, 0, 20, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 5, 5, 6, 25, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ILookingTamableMobStateGoal(this, 6, 6, 6, 80, 100){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
    }

    public void m_8107_() {
        super.m_8107_();
        this.stopAttackingAllies();
        if (!this.m_9236_().f_46443_ && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "sitidle") {
            return this.sitidleAnimationState;
        }
        if (input == "awake") {
            return this.awakeAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "biteattack") {
            return this.biteAnimationState;
        }
        if (input == "death") {
            return this.deathAnimationState;
        }
        if (input == "roar") {
            return this.roarAnimationState;
        }
        if (input == "shockwaves") {
            return this.shockwaveAnimationState;
        }
        if (input == "stomp") {
            return this.stompsAnimationState;
        }
        if (input == "tail") {
            return this.tailAnimationState;
        }
        if (input == "sitstart") {
            return this.sitstartAnimationState;
        }
        if (input == "sitend") {
            return this.sitendAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.roarAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.shockwaveAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.tailAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.stompsAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.sitstartAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.sitidleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.sitendAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.sleepAnimationState.m_216973_();
        this.awakeAnimationState.m_216973_();
        this.tailAnimationState.m_216973_();
        this.tailmAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.shockwaveAnimationState.m_216973_();
        this.roarAnimationState.m_216973_();
        this.biteAnimationState.m_216973_();
        this.stompsAnimationState.m_216973_();
        this.sitendAnimationState.m_216973_();
        this.sitstartAnimationState.m_216973_();
        this.sitidleAnimationState.m_216973_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, (double)0.05f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22288_, 0.9);
    }

    protected void playGallopSound(SoundType pSoundType) {
        if (Math.random() < 0.5) {
            this.m_5496_((SoundEvent)ModSounds.STEP_SOUND.get(), pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
        } else {
            this.m_5496_((SoundEvent)ModSounds.STEP_SOUND3.get(), pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        if (!pBlock.m_278721_()) {
            BlockState blockstate = this.m_9236_().m_8055_(pPos.m_7494_());
            SoundType soundtype = pBlock.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            if (blockstate.m_60713_(Blocks.f_50125_)) {
                soundtype = blockstate.getSoundType((LevelReader)this.m_9236_(), pPos, (Entity)this);
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopSoundCounter;
                if (this.gallopSoundCounter > 4 && this.gallopSoundCounter % 2 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopSoundCounter <= 4) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (this.isWoodSoundType(soundtype)) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    private boolean isWoodSoundType(SoundType pSoundType) {
        return pSoundType == SoundType.f_56736_ || pSoundType == SoundType.f_244244_ || pSoundType == SoundType.f_56763_ || pSoundType == SoundType.f_271497_ || pSoundType == SoundType.f_243772_;
    }

    protected float m_6108_() {
        return 0.96f;
    }

    public void performAreaAttack() {
        double attackRadius = 3.0;
        double attackHeight = 3.0;
        AABB attackBox = new AABB(this.m_20185_() - attackRadius, this.m_20186_(), this.m_20189_() - attackRadius, this.m_20185_() + attackRadius, this.m_20186_() + attackHeight, this.m_20189_() + attackRadius);
        List entities = this.m_9236_().m_45933_((Entity)this, attackBox);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || entity == this) continue;
            this.m_7327_((Entity)((LivingEntity)entity));
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        boolean var = true;
        int var2 = 2;
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
        emerald = this.getItemWithLootingEnchant(emerald, source.m_7639_());
        this.m_19983_(emerald);
    }

    private ItemStack getItemWithLootingEnchant(ItemStack stack, Entity killer) {
        int lootingLevel;
        if (killer instanceof Player && (lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)((LivingEntity)killer))) > 0) {
            stack.m_41769_(lootingLevel);
        }
        return stack;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268468_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_) && this.reduceFallDamage && this.m_20160_()) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
    }

    public boolean canBeControlledByRider() {
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            if (!this.canTravel()) {
                super.m_7023_(new Vec3(0.0, travelVector.f_82480_, 0.0));
                return;
            }
            LivingEntity livingentity = this.m_6688_();
            this.m_146922_(livingentity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(livingentity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float strafe = livingentity.f_20900_ * 0.1f;
            float forward = livingentity.f_20902_;
            super.m_7023_(new Vec3((double)strafe, travelVector.f_82480_, (double)forward));
            return;
        }
        if (!this.canTravel()) {
            super.m_7023_(new Vec3(0.0, travelVector.f_82480_, 0.0));
            return;
        }
        super.m_7023_(travelVector);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6129_() {
        return true;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.SKELETOSAURUS_HURT3.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.SKELETOSAURUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
            if (!this.isSitting()) {
                this.setAttackState(6);
                this.m_21839_(true);
            } else {
                this.setAttackState(7);
                this.m_21839_(false);
            }
            return InteractionResult.CONSUME;
        }
        if (this.m_6898_(itemstack) && !this.m_21824_()) {
            this.m_142075_(player, hand, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        InteractionResult interactionresult1 = super.m_6071_(player, hand);
        if (interactionresult1.m_19077_()) {
            this.m_21530_();
            return interactionresult1;
        }
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemstack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (!this.m_6162_() && (this.m_21830_((LivingEntity)player) || this.m_21824_()) && !this.isSitting()) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42579_ || stack.m_41720_() == Items.f_42658_ || stack.m_41720_() == Items.f_42485_ || stack.m_41720_() == Items.f_42581_ || stack.m_41720_() == Items.f_42697_;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean pJumping) {
        this.isJumping = pJumping;
    }

    protected void playJumpSound() {
        this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        } else {
            this.allowStandSliding = true;
            this.standIfPossible();
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public boolean m_7132_() {
        return true;
    }

    public void standIfPossible() {
    }

    public void m_7199_(int pJumpPower) {
        this.allowStandSliding = true;
        this.standIfPossible();
        this.playJumpSound();
    }

    public void m_8012_() {
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        if (this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.m_20096_()) {
                this.executeRidersJump(this.playerJumpPendingScale, pTravelVector);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected void executeRidersJump(float p_248808_, Vec3 p_275435_) {
        double d0 = this.getCustomJump() * (double)p_248808_ * (double)this.m_20098_();
        double d1 = d0 + (double)this.m_285755_();
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
        this.setIsJumping(true);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (p_275435_.f_82481_ > 0.0) {
            float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f * p_248808_), 0.0, (double)(0.4f * f1 * p_248808_)));
        }
    }

    protected static double generateJumpStrength(DoubleSupplier pSupplier) {
        return (double)0.4f + pSupplier.getAsDouble() * 0.2 + pSupplier.getAsDouble() * 0.2 + pSupplier.getAsDouble() * 0.2;
    }
}

