/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.block.entity.ModBlockEntities;
import com.delta.redeco.block.entity.custom.SpyglassStandBlockEntity;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpyglassStandBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5);
    private static final VoxelShape ATTACHED_NORTH = Stream.of(Block.m_49796_((double)6.75, (double)7.25, (double)2.0, (double)9.25, (double)9.75, (double)14.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape ATTACHED_SOUTH = Stream.of(Block.m_49796_((double)6.75, (double)7.0, (double)2.0, (double)9.25, (double)9.5, (double)14.0), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape ATTACHED_EAST = Stream.of(Block.m_49796_((double)2.0, (double)7.0, (double)6.75, (double)14.0, (double)9.5, (double)9.25), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape ATTACHED_WEST = Stream.of(Block.m_49796_((double)2.0, (double)7.25, (double)6.75, (double)14.0, (double)9.75, (double)9.25), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)8.0, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public SpyglassStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.m_61143_((Property)ATTACHED)).booleanValue()) {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case SOUTH: {
                    return ATTACHED_NORTH;
                }
                case WEST: {
                    return ATTACHED_WEST;
                }
                case EAST: {
                    return ATTACHED_EAST;
                }
            }
            return ATTACHED_SOUTH;
        }
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ATTACHED, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof SpyglassStandBlockEntity) {
            SpyglassStandBlockEntity SpyglassStandEntity = (SpyglassStandBlockEntity)tileEntity;
            ItemStack heldStack = player.m_21120_(hand);
            ItemStack offhandStack = player.m_21206_();
            if (SpyglassStandEntity.isEmpty() && heldStack.m_41720_() == Items.f_151059_) {
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (SpyglassStandEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12027_, SoundSource.BLOCKS, 1.0f, 1.1f);
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)player.m_6350_()), 2);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.m_41619_()) {
                    return InteractionResult.CONSUME;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.m_7500_()) {
                        if (!player.m_150109_().m_36054_(SpyglassStandEntity.removeItem())) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)SpyglassStandEntity.removeItem());
                        }
                    } else {
                        SpyglassStandEntity.removeItem();
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)), 2);
                    }
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12027_, SoundSource.BLOCKS, 1.0f, 1.1f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof SpyglassStandBlockEntity) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((SpyglassStandBlockEntity)tileEntity).getStoredItem());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.SPYGLASS_STAND_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }
}

