/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items.complex;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7800;
import org.betterx.bclib.items.complex.EquipmentDescription;
import org.betterx.bclib.items.complex.EquipmentSlot;
import org.betterx.bclib.registry.ItemRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class EquipmentSet {
    public final class_1832 material;
    public final String baseName;
    public final String modID;
    public final class_1935 stick;
    public static final EquipmentSlot PICKAXE_SLOT = new EquipmentSlot("pickaxe", class_7800.field_40638);
    public static final EquipmentSlot AXE_SLOT = new EquipmentSlot("axe", class_7800.field_40638);
    public static final EquipmentSlot SHOVEL_SLOT = new EquipmentSlot("shovel", class_7800.field_40638);
    public static final EquipmentSlot SWORD_SLOT = new EquipmentSlot("sword", class_7800.field_40639);
    public static final EquipmentSlot HOE_SLOT = new EquipmentSlot("hoe", class_7800.field_40638);
    public static final EquipmentSlot SHEARS_SLOT = new EquipmentSlot("shears", class_7800.field_40638);
    public static final EquipmentSlot HELMET_SLOT = new EquipmentSlot("helmet", class_7800.field_40639);
    public static final EquipmentSlot CHESTPLATE_SLOT = new EquipmentSlot("chestplate", class_7800.field_40639);
    public static final EquipmentSlot LEGGINGS_SLOT = new EquipmentSlot("leggings", class_7800.field_40639);
    public static final EquipmentSlot BOOTS_SLOT = new EquipmentSlot("boots", class_7800.field_40639);
    public final SetValues attackDamage;
    public final SetValues attackSpeed;
    private final Map<EquipmentSlot, EquipmentDescription<?>> descriptions = new HashMap();
    protected final EquipmentSet sourceSet;

    public EquipmentSet(class_1832 material, String modID, String baseName, class_1935 stick, SetValues attackDamage, SetValues attackSpeed) {
        this(material, modID, baseName, stick, null, attackDamage, attackSpeed);
    }

    public EquipmentSet(class_1832 material, String modID, String baseName, class_1935 stick, EquipmentSet sourceSet, SetValues attackDamage, SetValues attackSpeed) {
        this.material = material;
        this.baseName = baseName;
        this.modID = modID;
        this.stick = stick;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.sourceSet = sourceSet;
    }

    protected <I extends class_1792> void add(EquipmentSlot slot, EquipmentDescription<I> desc) {
        this.descriptions.put(slot, desc);
    }

    protected <I extends class_1792> void add(EquipmentSlot slot, EquipmentSet baseSet, ItemDescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<class_1792> desc = descriptor.build(slot, (class_1792)baseSet.getSlot(slot), tier -> item.build((class_1832)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    protected <I extends class_1792> void add(EquipmentSlot slot, DescriptorCreator<I> descriptor, ItemCreator<I> item) {
        EquipmentDescription<class_1792> desc = descriptor.build(slot, tier -> item.build((class_1832)tier, this.attackDamage.get(slot), this.attackSpeed.get(slot)));
        this.descriptions.put(slot, desc);
    }

    public EquipmentSet init(ItemRegistry itemsRegistry) {
        for (Map.Entry<EquipmentSlot, EquipmentDescription<?>> desc : this.descriptions.entrySet()) {
            desc.getValue().init(this.buildID(desc), itemsRegistry, this.material, this.stick, this.sourceSet);
        }
        return this;
    }

    @NotNull
    protected class_2960 buildID(Map.Entry<EquipmentSlot, EquipmentDescription<?>> desc) {
        return new class_2960(this.modID, this.baseName + "_" + desc.getKey().name());
    }

    public <I extends class_1792> I getSlot(EquipmentSlot slot) {
        return (I)this.descriptions.get(slot).getItem();
    }

    public static class SetValues {
        private final Map<EquipmentSlot, Float> values = new HashMap<EquipmentSlot, Float>();

        private SetValues() {
        }

        public static SetValues create() {
            return new SetValues();
        }

        public static SetValues copy(SetValues source, float offset) {
            SetValues v = SetValues.create();
            for (Map.Entry<EquipmentSlot, Float> e : source.values.entrySet()) {
                v.add(e.getKey(), e.getValue().floatValue() + offset);
            }
            return v;
        }

        public SetValues add(EquipmentSlot slot, float value) {
            this.values.put(slot, Float.valueOf(value));
            return this;
        }

        public SetValues offset(EquipmentSlot slot, float offset) {
            this.values.put(slot, Float.valueOf(this.get(slot) + offset));
            return this;
        }

        public float get(EquipmentSlot slot) {
            return this.values.getOrDefault(slot, Float.valueOf(0.0f)).floatValue();
        }
    }

    public static interface ItemCreator<I extends class_1792> {
        public I build(class_1832 var1, float var2, float var3);
    }

    public static interface ItemDescriptorCreator<I extends class_1792> {
        public EquipmentDescription<I> build(EquipmentSlot var1, class_1792 var2, Function<class_1832, I> var3);
    }

    public static interface DescriptorCreator<I extends class_1792> {
        public EquipmentDescription<I> build(EquipmentSlot var1, Function<class_1832, I> var2);
    }

    public static class AttackSpeed {
        public static SetValues WOOD_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.2f).add(HOE_SLOT, -3.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.2f).add(HOE_SLOT, -2.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.0f).add(HOE_SLOT, -3.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.1f).add(HOE_SLOT, -1.0f);
        public static SetValues DIAMOND_LEVEL;
        public static SetValues NETHERITE_LEVEL;

        static {
            NETHERITE_LEVEL = DIAMOND_LEVEL = SetValues.create().add(SWORD_SLOT, -2.4f).add(SHOVEL_SLOT, -3.0f).add(PICKAXE_SLOT, -2.8f).add(AXE_SLOT, -3.0f).add(HOE_SLOT, 0.0f);
        }
    }

    public static class AttackDamage {
        public static SetValues WOOD_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, 0.0f);
        public static SetValues STONE_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 7.0f).add(HOE_SLOT, -1.0f);
        public static SetValues GOLDEN_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, 0.0f);
        public static SetValues IRON_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 6.0f).add(HOE_SLOT, -2.0f);
        public static SetValues DIAMOND_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 5.0f).add(HOE_SLOT, -3.0f);
        public static SetValues NETHERITE_LEVEL = SetValues.create().add(SWORD_SLOT, 3.0f).add(SHOVEL_SLOT, 1.5f).add(PICKAXE_SLOT, 1.0f).add(AXE_SLOT, 5.0f).add(HOE_SLOT, -4.0f);
    }
}

