/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1086;
import net.minecraft.class_1100;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_793;
import net.minecraft.class_807;
import net.minecraft.class_813;
import org.betterx.bclib.blocks.BaseTerrainBlock;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.jetbrains.annotations.Nullable;

public class TripleTerrainBlock
extends BaseTerrainBlock {
    public static final class_2754<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public TripleTerrainBlock(class_2248 baseBlock) {
        super(baseBlock, baseBlock.method_26403());
        this.method_9590((class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    public TripleTerrainBlock(class_2248 baseBlock, class_3620 color) {
        super(baseBlock, color);
        this.method_9590((class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{SHAPE});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 dir = ctx.method_8038();
        BlockProperties.TripleShape shape = dir == class_2350.field_11036 ? BlockProperties.TripleShape.BOTTOM : (dir == class_2350.field_11033 ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE);
        return (class_2680)this.method_9564().method_11657(SHAPE, (Comparable)((Object)shape));
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.method_11654(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return super.method_9534(state, world, pos, player, hand, hit);
        }
        return class_1269.field_5814;
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.method_11654(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            super.method_9514(state, world, pos, random);
        } else if (random.method_43048(16) == 0) {
            boolean bottom = this.canStayBottom((class_4538)world, pos);
            if (shape == BlockProperties.TripleShape.TOP) {
                if (!bottom) {
                    world.method_8501(pos, class_2246.field_10471.method_9564());
                }
            } else {
                boolean top;
                boolean bl = top = this.canStay(state, (class_4538)world, pos) || this.isMiddle(world.method_8320(pos.method_10084()));
                if (!top && !bottom) {
                    world.method_8501(pos, class_2246.field_10471.method_9564());
                } else if (top && !bottom) {
                    world.method_8501(pos, (class_2680)state.method_11657(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
                } else if (!top) {
                    world.method_8501(pos, (class_2680)state.method_11657(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
                }
            }
        }
    }

    protected boolean canStayBottom(class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        if (this.isMiddle(blockState)) {
            return true;
        }
        if (blockState.method_26227().method_15761() == 8) {
            return false;
        }
        return !blockState.method_26206((class_1922)world, blockPos, class_2350.field_11036);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_793 getItemModel(class_2960 blockId) {
        return this.getBlockModel(blockId, this.method_9564());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_793 getBlockModel(class_2960 blockId, class_2680 blockState) {
        Optional<String> pattern;
        String path = blockId.method_12832();
        if (this.isMiddle(blockState)) {
            class_2960 topId = new class_2960(blockId.method_12836(), path + "_top");
            pattern = PatternsHelper.createBlockSimple(topId);
        } else {
            HashMap textures = Maps.newHashMap();
            textures.put("%top%", "betterend:block/" + path + "_top");
            textures.put("%side%", "betterend:block/" + path + "_side");
            textures.put("%bottom%", "minecraft:block/end_stone");
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_TOP_SIDE_BOTTOM, textures);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_1100 getModelVariant(class_2960 stateId, class_2680 blockState, Map<class_2960, class_1100> modelCache) {
        boolean isMiddle = this.isMiddle(blockState);
        String middle = isMiddle ? "_middle" : "";
        class_2960 modelId = new class_2960(stateId.method_12836(), "block/" + stateId.method_12832() + middle);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        if (isMiddle) {
            ArrayList variants = Lists.newArrayList();
            for (class_1086 rotation : class_1086.values()) {
                variants.add(new class_813(modelId, rotation.method_3509(), false, 1));
            }
            return new class_807((List)variants);
        }
        if (blockState.method_11654(SHAPE) == BlockProperties.TripleShape.TOP) {
            return new class_807((List)Lists.newArrayList((Object[])new class_813[]{new class_813(modelId, class_1086.field_5358.method_3509(), false, 1), new class_813(modelId, class_1086.field_5348.method_3509(), false, 1), new class_813(modelId, class_1086.field_5356.method_3509(), false, 1), new class_813(modelId, class_1086.field_5359.method_3509(), false, 1)}));
        }
        return ModelsHelper.createRandomTopModel(modelId);
    }

    protected boolean isMiddle(class_2680 blockState) {
        return blockState.method_27852((class_2248)this) && blockState.method_11654(SHAPE) == BlockProperties.TripleShape.MIDDLE;
    }
}

