/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.datagen;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import org.betterx.worlds.together.tag.v3.TagRegistry;
import org.jetbrains.annotations.Nullable;

public class TagDataProvider<T>
extends FabricTagProvider<T> {
    @Nullable
    protected final List<String> modIDs;
    protected final TagRegistry<T> tagRegistry;
    private final Set<class_6862<T>> forceWrite;

    public TagDataProvider(TagRegistry<T> tagRegistry, @Nullable List<String> modIDs, FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this(tagRegistry, modIDs, Set.of(), output, registriesFuture);
    }

    public TagDataProvider(TagRegistry<T> tagRegistry, @Nullable List<String> modIDs, Set<class_6862<T>> forceWriteKeys, FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, tagRegistry.registryKey, registriesFuture);
        this.tagRegistry = tagRegistry;
        this.modIDs = modIDs;
        this.forceWrite = forceWriteKeys;
    }

    protected boolean shouldAdd(class_2960 loc) {
        return this.modIDs == null || this.modIDs.contains(loc.method_12836());
    }

    protected boolean isOptional(class_3497 e) {
        return e.method_32832(id -> false, id -> false);
    }

    protected void method_10514(class_7225.class_7874 arg) {
        this.tagRegistry.forEachEntry((tag, locs, tags) -> {
            if (!this.forceWrite.contains(tag) && locs.isEmpty() && tags.isEmpty()) {
                return;
            }
            FabricTagProvider.FabricTagBuilder builder = this.getOrCreateTagBuilder((class_6862)tag);
            locs.sort(Comparator.comparing(a -> ((class_2960)a.first).toString()));
            tags.sort(Comparator.comparing(a -> ((class_6862)a.first).comp_327().toString()));
            locs.forEach(pair -> {
                if (this.isOptional((class_3497)pair.second)) {
                    builder.addOptional((class_2960)pair.first);
                } else {
                    builder.add((class_2960)pair.first);
                }
            });
            tags.forEach(pair -> {
                if (this.isOptional((class_3497)pair.second)) {
                    builder.addOptionalTag((class_6862)pair.first);
                } else {
                    builder.forceAddTag((class_6862)pair.first);
                }
            });
        }, (tag, loc) -> this.forceWrite.contains(tag) || this.shouldAdd(tag.comp_327()) || this.shouldAdd((class_2960)loc));
    }
}

