/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5847;
import net.minecraft.class_6862;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7061;
import net.minecraft.class_7151;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructureBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class BCLStructure<S extends class_3195> {
    protected final class_2893.class_2895 featureStep;
    protected final List<class_2960> biomes = Lists.newArrayList();
    protected final class_2960 id;
    public final class_6862<class_1959> biomeTag;
    public final class_5321<class_3195> structureKey;
    public final class_5321<class_7059> structureSetKey;
    public final class_6874 spreadConfig;
    public final class_7151<S> structureType;
    private boolean registeredSet = false;

    private static class_6885<class_1959> biomes(class_7891<class_3195> bootstrapContext, class_6862<class_1959> tagKey) {
        return bootstrapContext.method_46799(class_7924.field_41236).method_46735(tagKey);
    }

    private static class_3195.class_7302 structure(class_7891<class_3195> bootstrapContext, class_6862<class_1959> tagKey, Map<class_1311, class_7061> map, class_2893.class_2895 decoration, class_5847 terrainAdjustment) {
        return new class_3195.class_7302(BCLStructure.biomes(bootstrapContext, tagKey), map, decoration, terrainAdjustment);
    }

    private static class_3195.class_7302 structure(class_7891<class_3195> bootstrapContext, class_6862<class_1959> tagKey, class_2893.class_2895 decoration, class_5847 terrainAdjustment) {
        return BCLStructure.structure(bootstrapContext, tagKey, Map.of(), decoration, terrainAdjustment);
    }

    private static <S extends class_3195> class_7151<S> registerStructureType(class_2960 id, Codec<S> codec) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41231, (class_2960)id);
        return (class_7151)class_2378.method_39197((class_2378)class_7923.field_41147, (class_5321)key, () -> codec);
    }

    protected BCLStructure(@NotNull class_2960 id, @NotNull class_5321<class_3195> structureKey, @NotNull class_5321<class_7059> structureSetKey, @NotNull class_2893.class_2895 step, @NotNull class_6874 placement, @NotNull class_6862<class_1959> biomeTag, @NotNull class_7151<S> structureType) {
        this.id = id;
        this.featureStep = step;
        this.spreadConfig = placement;
        this.structureKey = structureKey;
        this.structureSetKey = structureSetKey;
        this.biomeTag = biomeTag;
        this.structureType = structureType;
    }

    public static boolean isValidBiome(class_3195.class_7149 context) {
        return BCLStructure.isValidBiome(context, 5);
    }

    public static boolean isValidBiome(class_3195.class_7149 context, int yPos) {
        class_2338 blockPos = context.comp_568().method_33943(yPos);
        return context.comp_570().test(context.comp_562().method_12098().method_38109(class_5742.method_33100((int)blockPos.method_10263()), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33100((int)blockPos.method_10260()), context.comp_564().method_42371()));
    }

    public class_2893.class_2895 getFeatureStep() {
        return this.featureStep;
    }

    public class_2960 getID() {
        return this.id;
    }

    public void addInternalBiome(class_2960 biome) {
        this.biomes.add(biome);
    }

    public List<class_2960> getBiomes() {
        return this.biomes;
    }

    public void registerSet(class_7891<class_7059> bootstrapContext) {
        if (this.registeredSet) {
            return;
        }
        this.registeredSet = true;
        bootstrapContext.method_46838(this.structureSetKey, (Object)new class_7059((class_6880)bootstrapContext.method_46799(class_7924.field_41246).method_46747(this.structureKey), this.spreadConfig));
        BCLStructureBuilder.UNBOUND_STRUCTURE_SETS.remove(this);
    }

    public abstract Bound<S> register(class_7891<class_3195> var1);

    public static class Bound<S extends class_3195>
    extends BCLStructure<S> {
        public final S baseStructure;
        public final class_6880<class_3195> structure;

        private Bound(@NotNull class_2960 id, @NotNull class_5321<class_3195> structureKey, @NotNull class_5321<class_7059> structureSetKey, @NotNull class_2893.class_2895 featureStep, @NotNull class_6874 placement, @NotNull class_6862<class_1959> biomeTag, @NotNull class_7151<S> structureType, @NotNull S baseStructure, @NotNull class_6880<class_3195> structure) {
            super(id, structureKey, structureSetKey, featureStep, placement, biomeTag, structureType);
            this.baseStructure = baseStructure;
            this.structure = structure;
        }

        public class_6880<class_3195> getStructure() {
            return this.structure;
        }

        @Override
        public Bound<S> register(class_7891<class_3195> bootstrapContext) {
            return this;
        }
    }

    public static class Unbound<S extends class_3195>
    extends BCLStructure<S> {
        private final StructureBuilder<S> structureBuilder;
        private final class_5847 terrainAdjustment;
        private Bound<S> registered = null;

        protected Unbound(@NotNull class_2960 id, @NotNull class_2893.class_2895 step, @NotNull class_6874 placement, @NotNull Codec<S> codec, @NotNull class_6862<class_1959> biomeTag, @NotNull StructureBuilder<S> structureBuilder, @NotNull class_5847 terrainAdjustment) {
            super(id, (class_5321<class_3195>)class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)id), (class_5321<class_7059>)class_5321.method_29179((class_5321)class_7924.field_41248, (class_2960)id), step, placement, biomeTag, BCLStructure.registerStructureType(id, codec));
            this.structureBuilder = structureBuilder;
            this.terrainAdjustment = terrainAdjustment;
        }

        @Override
        public Bound<S> register(class_7891<class_3195> bootstrapContext) {
            S baseStructure;
            if (this.registered != null) {
                return this.registered;
            }
            class_3195.class_7302 settings = BCLStructure.structure(bootstrapContext, (class_6862<class_1959>)this.biomeTag, this.featureStep, this.terrainAdjustment);
            StructureBuilder<S> structureBuilder = this.structureBuilder;
            if (structureBuilder instanceof StructureBuilderWithContext) {
                StructureBuilderWithContext sctx = (StructureBuilderWithContext)structureBuilder;
                baseStructure = sctx.apply(settings, bootstrapContext);
            } else {
                baseStructure = this.structureBuilder.apply(settings);
            }
            class_6880.class_6883 structure = bootstrapContext.method_46838(this.structureKey, baseStructure);
            BCLStructureBuilder.UNBOUND_STRUCTURES.remove(this);
            this.registered = new Bound<S>(this.id, (class_5321<class_3195>)this.structureKey, (class_5321<class_7059>)this.structureSetKey, this.featureStep, this.spreadConfig, (class_6862<class_1959>)this.biomeTag, this.structureType, baseStructure, (class_6880<class_3195>)structure);
            return this.registered;
        }
    }

    public static interface StructureBuilderWithContext<S extends class_3195>
    extends StructureBuilder<S> {
        @Override
        default public S apply(class_3195.class_7302 structureSettings) {
            return this.apply(structureSettings, null);
        }

        public S apply(class_3195.class_7302 var1, class_7891<class_3195> var2);
    }

    public static interface StructureCodecProvider<S extends class_3195> {
        public Codec<S> getCodec();
    }

    public static interface StructureBuilder<S extends class_3195> {
        public S apply(class_3195.class_7302 var1);
    }
}

