/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6544;
import net.minecraft.class_7243;
import net.minecraft.class_7924;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeData;
import org.betterx.bclib.util.WeightedList;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BCLBiome
implements BiomeData {
    public static final Codec<BCLBiome> CODEC = RecordCodecBuilder.create(instance -> BCLBiome.codecWithSettings(instance).apply((Applicative)instance, BCLBiome::new));
    public static final class_7243<? extends BCLBiome> KEY_CODEC = class_7243.method_42115(CODEC);
    public final BCLBiomeSettings settings;
    private final Map<String, Object> customData = Maps.newHashMap();
    private final class_2960 biomeID;
    private final class_5321<class_1959> biomeKey;
    protected final List<class_6544.class_4762> parameterPoints = Lists.newArrayList();
    private class_2960 biomeParent;
    private class_2960 edge;
    private BiomeAPI.BiomeType intendedType = BiomeAPI.BiomeType.NONE;
    private final boolean didLoadConfig = false;
    @ApiStatus.Internal
    private class_1959 biomeToRegister;

    @Override
    public class_7243<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    public static <T extends BCLBiome, P11> Products.P11<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<String>, P11> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11);
    }

    public static <T extends BCLBiome, P11, P12> Products.P12<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<String>, P11, P12> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12);
    }

    public static <T extends BCLBiome, P11, P12, P13, P14> Products.P14<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<String>, P11, P12, P13, P14> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12, p13, p14);
    }

    public static <T extends BCLBiome, P11, P12, P13> Products.P13<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<String>, P11, P12, P13> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12, p13);
    }

    public static <T extends BCLBiome> Products.P10<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<String>> codecWithSettings(RecordCodecBuilder.Instance<T> instance) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10);
    }

    protected BCLBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<class_2960> edge, class_2960 biomeID, Optional<List<class_6544.class_4762>> parameterPoints, Optional<class_2960> biomeParent, Optional<String> intendedType) {
        this.settings = new BCLBiomeSettings(terrainHeight, fogDensity, genChance, edgeSize, vertical);
        this.edge = edge.orElse(null);
        this.biomeID = biomeID;
        this.biomeKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID);
        this.biomeParent = biomeParent.orElse(null);
        if (parameterPoints.isPresent()) {
            this.parameterPoints.addAll((Collection<class_6544.class_4762>)parameterPoints.get());
        }
        this.setIntendedType(intendedType.map(t -> BiomeAPI.BiomeType.create(t)).orElse(BiomeAPI.BiomeType.NONE));
    }

    protected BCLBiome(class_5321<class_1959> biomeKey) {
        this(biomeKey.method_29177());
    }

    protected BCLBiome(class_2960 biomeID) {
        this((class_5321<class_1959>)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID), null);
    }

    @ApiStatus.Internal
    public BCLBiome(class_2960 biomeID, BiomeAPI.BiomeType type) {
        this((class_5321<class_1959>)class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID), (BCLBiomeSettings)null);
        this.setIntendedType(type);
    }

    protected BCLBiome(class_5321<class_1959> biomeKey, BCLBiomeSettings defaults) {
        this.settings = defaults == null ? new BCLBiomeSettings() : defaults;
        this.biomeID = biomeKey.method_29177();
        this.biomeKey = biomeKey;
    }

    protected BCLBiome(class_2960 biomeID, BCLBiomeSettings defaults) {
        this.settings = defaults == null ? new BCLBiomeSettings() : defaults;
        this.biomeID = biomeID;
        this.biomeKey = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)biomeID);
    }

    protected BCLBiome setIntendedType(BiomeAPI.BiomeType type) {
        return this._setIntendedType(type);
    }

    BCLBiome _setIntendedType(BiomeAPI.BiomeType type) {
        this.intendedType = type;
        return this;
    }

    public BiomeAPI.BiomeType getIntendedType() {
        return this.intendedType;
    }

    @Nullable
    public BCLBiome getEdge() {
        return BiomeAPI.getBiome(this.edge);
    }

    public boolean hasEdge() {
        return !BCLBiomeRegistry.isEmptyBiome(this.edge);
    }

    BCLBiome _setEdge(BCLBiome edge) {
        if (edge != null) {
            this.edge = edge.biomeID;
            edge.biomeParent = this.biomeID;
        } else {
            this.edge = null;
        }
        return this;
    }

    public BCLBiome addEdge(BCLBiome newEdge) {
        if (this.edge != null) {
            newEdge.biomeParent = this.edge;
        } else {
            this._setEdge(newEdge);
        }
        return this;
    }

    public BCLBiome addSubBiome(BCLBiome biome) {
        biome.biomeParent = this.biomeID;
        return this;
    }

    private WeightedList<BCLBiome> getSubBiomes() {
        class_5455 acc = WorldBootstrap.getLastRegistryAccess();
        WeightedList<BCLBiome> subbiomes = new WeightedList<BCLBiome>();
        subbiomes.add(this, 1.0f);
        if (acc == null) {
            return subbiomes;
        }
        class_2370<BCLBiome> reg = acc.method_33310(BCLBiomeRegistry.BCL_BIOMES_REGISTRY).orElse(null);
        if (reg == null) {
            reg = BCLBiomeRegistry.BUILTIN_BCL_BIOMES;
        }
        for (Map.Entry entry : reg.method_29722()) {
            BCLBiome b = (BCLBiome)entry.getValue();
            if (!this.biomeID.equals((Object)((BCLBiome)entry.getValue()).biomeParent) || ((BCLBiome)entry.getValue()).isEdgeBiome()) continue;
            subbiomes.add(b, b.settings.genChance);
        }
        return subbiomes;
    }

    public void forEachSubBiome(BiConsumer<BCLBiome, Float> consumer) {
        WeightedList<BCLBiome> subbiomes = this.getSubBiomes();
        for (int i = 0; i < subbiomes.size(); ++i) {
            consumer.accept(subbiomes.get(i), Float.valueOf(subbiomes.getWeight(i)));
        }
    }

    @Nullable
    public BCLBiome getParentBiome() {
        return BiomeAPI.getBiome(this.biomeParent);
    }

    public boolean hasParentBiome() {
        return !BCLBiomeRegistry.isEmptyBiome(this.biomeParent);
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.biomeParent != null && biome.biomeParent.equals((Object)this.biomeID);
    }

    public class_2960 getID() {
        return this.biomeID;
    }

    public class_5321<class_1959> getBiomeKey() {
        return this.biomeKey;
    }

    public class_5321<BCLBiome> getBCLBiomeKey() {
        return class_5321.method_29179(BCLBiomeRegistry.BCL_BIOMES_REGISTRY, (class_2960)this.biomeID);
    }

    void afterRegistration() {
    }

    public boolean is(class_5321<class_1959> key) {
        return this.biomeID.equals((Object)key.method_29177());
    }

    public boolean is(class_2960 loc) {
        return this.biomeID.equals((Object)loc);
    }

    public boolean is(BCLBiome biome) {
        if (biome == null) {
            return false;
        }
        return this.biomeID.equals((Object)biome.biomeID);
    }

    public boolean equals(class_5321<class_1959> key) {
        return this.is(key);
    }

    public boolean equals(class_2960 loc) {
        return this.is(loc);
    }

    public boolean equals(BCLBiome biome) {
        return this.is(biome);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BCLBiome) {
            BCLBiome biome = (BCLBiome)obj;
            return this.is(biome);
        }
        if (obj instanceof class_5321) {
            class_5321 key = (class_5321)obj;
            return this.is((class_5321<class_1959>)key);
        }
        if (obj instanceof class_2960) {
            class_2960 loc = (class_2960)obj;
            return this.is(loc);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.biomeID.hashCode();
    }

    public String toString() {
        return this.biomeID.toString();
    }

    void addClimateParameters(List<class_6544.class_4762> params) {
        this.parameterPoints.addAll(params);
    }

    public void forEachClimateParameter(Consumer<class_6544.class_4762> consumer) {
        this.parameterPoints.forEach(consumer);
    }

    public String configGroup() {
        return this.biomeID.method_12836() + "." + this.biomeID.method_12832();
    }

    public boolean isEdgeBiome() {
        BCLBiome parent = this.getParentBiome();
        if (parent == null) {
            return false;
        }
        return this.biomeID.equals((Object)parent.edge);
    }

    boolean allowFabricRegistration() {
        return !this.isEdgeBiome();
    }

    @ApiStatus.Internal
    void _setBiomeToRegister(class_1959 b) {
        this.biomeToRegister = b;
    }

    @ApiStatus.Internal
    class_1959 _getBiomeToRegister() {
        return this.biomeToRegister;
    }

    @ApiStatus.Internal
    boolean _hasBiomeToRegister() {
        return this.biomeToRegister != null;
    }

    private static class CodecAttributes<T extends BCLBiome> {
        public RecordCodecBuilder<T, Float> t0 = Codec.FLOAT.fieldOf("terrainHeight").orElse((Object)Float.valueOf(0.1f)).forGetter(o1 -> Float.valueOf(o1.settings.terrainHeight));
        public RecordCodecBuilder<T, Float> t1 = Codec.FLOAT.fieldOf("fogDensity").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.settings.fogDensity));
        public RecordCodecBuilder<T, Float> t2 = Codec.FLOAT.fieldOf("genChance").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.settings.genChance));
        public RecordCodecBuilder<T, Integer> t3 = Codec.INT.fieldOf("edgeSize").orElse((Object)0).forGetter(o1 -> o1.settings.edgeSize);
        public RecordCodecBuilder<T, Boolean> t4 = Codec.BOOL.fieldOf("vertical").orElse((Object)false).forGetter(o1 -> o1.settings.vertical);
        public RecordCodecBuilder<T, Optional<class_2960>> t5 = class_2960.field_25139.optionalFieldOf("edge").orElse(Optional.empty()).forGetter(o1 -> o1.edge == null ? Optional.empty() : Optional.of(o1.edge));
        public RecordCodecBuilder<T, class_2960> t6 = class_2960.field_25139.fieldOf("biome").forGetter(o -> o.biomeID);
        public RecordCodecBuilder<T, Optional<List<class_6544.class_4762>>> t7 = class_6544.class_4762.field_24679.listOf().optionalFieldOf("parameter_points").orElse(Optional.of(List.of())).forGetter(o -> o.parameterPoints == null || o.parameterPoints.isEmpty() ? Optional.empty() : Optional.of(o.parameterPoints));
        public RecordCodecBuilder<T, Optional<class_2960>> t8 = class_2960.field_25139.optionalFieldOf("parent").orElse(Optional.empty()).forGetter(o1 -> o1.biomeParent == null ? Optional.empty() : Optional.of(o1.biomeParent));
        public RecordCodecBuilder<T, Optional<String>> t10 = Codec.STRING.optionalFieldOf("intended_for").orElse(Optional.of(BiomeAPI.BiomeType.NONE.getName())).forGetter(o -> o.intendedType == null ? Optional.empty() : Optional.of(o.intendedType.getName()));

        private CodecAttributes() {
        }
    }
}

