/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class AtmosphericBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        AtmosphericBiomeModifiers.addFeature(context, "yucca_tree_desert", (ResourceKey<Biome>)Biomes.f_48203_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.DESERT_YUCCA_TREES);
        AtmosphericBiomeModifiers.addFeature(context, "yucca_tree_windswept_savanna", (ResourceKey<Biome>)Biomes.f_186768_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WINDSWEPT_SAVANNA_YUCCA_TREES);
        AtmosphericBiomeModifiers.addFeature(context, "wooded_badlands_vegetation", (ResourceKey<Biome>)Biomes.f_186753_, GenerationStep.Decoration.VEGETAL_DECORATION, AtmosphericFeatures.AtmosphericPlacedFeatures.WOODED_BADLANDS_YUCCA_TREES, AtmosphericFeatures.AtmosphericPlacedFeatures.PATCH_AGAVE_WOODED_BADLANDS);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        AtmosphericBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), AtmosphericBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        AtmosphericBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), AtmosphericBiomeModifiers.featureSet(context, features), step));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("atmospheric", name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

