/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.teamabnormals.atmospheric.client.model.CochinealModel;
import com.teamabnormals.atmospheric.client.model.DragonFruitModel;
import com.teamabnormals.atmospheric.client.model.PassionFruitSeedModel;
import com.teamabnormals.atmospheric.client.model.TetraModel;
import com.teamabnormals.atmospheric.client.renderer.entity.CochinealRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.DragonFruitRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.PassionFruitSeedRenderer;
import com.teamabnormals.atmospheric.client.renderer.entity.TetraRenderer;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericBlockStateProvider;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericItemModelProvider;
import com.teamabnormals.atmospheric.core.data.client.AtmosphericSpriteSourceProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericAdvancementProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericDatapackBuiltinEntriesProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericLootTableProvider;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericRecipeProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericAdvancementModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericChunkGeneratorModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.modifiers.AtmosphericLootModifierProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBannerPatternTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBiomeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericBlockTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericDamageTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericEntityTypeTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericItemTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericPaintingVariantTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericStructureTagsProvider;
import com.teamabnormals.atmospheric.core.data.server.tags.AtmosphericTrimMaterialTagsProvider;
import com.teamabnormals.atmospheric.core.other.AtmosphericClientCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericCompat;
import com.teamabnormals.atmospheric.core.other.AtmosphericModelLayers;
import com.teamabnormals.atmospheric.core.other.AtmosphericVillagers;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBannerPatterns;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericDecoratedPotPatterns;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import com.teamabnormals.atmospheric.core.registry.AtmosphericLootConditions;
import com.teamabnormals.atmospheric.core.registry.AtmosphericMobEffects;
import com.teamabnormals.atmospheric.core.registry.AtmosphericPaintingVariants;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericPlacementModifierTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import com.teamabnormals.atmospheric.core.registry.AtmosphericStructureProcessors;
import com.teamabnormals.atmospheric.core.registry.helper.AtmosphericBlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.gallery.core.data.client.GalleryAssetsRemolderProvider;
import com.teamabnormals.gallery.core.data.client.GalleryItemModelProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="atmospheric")
@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Atmospheric {
    public static final String MOD_ID = "atmospheric";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"atmospheric", helper -> helper.putSubHelper(ForgeRegistries.BLOCKS, (ISubRegistryHelper)new AtmosphericBlockSubRegistryHelper((RegistryHelper)helper)));

    public Atmospheric() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        AtmosphericFeatures.FEATURES.register(bus);
        AtmosphericFeatures.TREE_DECORATOR_TYPES.register(bus);
        AtmosphericPlacementModifierTypes.PLACEMENT_MODIFIER_TYPES.register(bus);
        AtmosphericParticleTypes.PARTICLES.register(bus);
        AtmosphericMobEffects.EFFECTS.register(bus);
        AtmosphericMobEffects.POTIONS.register(bus);
        AtmosphericLootConditions.LOOT_CONDITION_TYPES.register(bus);
        AtmosphericBannerPatterns.BANNER_PATTERNS.register(bus);
        AtmosphericStructureProcessors.STRUCTURE_PROCESSORS.register(bus);
        AtmosphericDecoratedPotPatterns.DECORATED_POT_PATTERNS.register(bus);
        AtmosphericPaintingVariants.PAINTING_VARIANTS.register(bus);
        bus.addListener(AtmosphericRegistries::registerRegistries);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            AtmosphericItems.setupTabEditors();
            AtmosphericBlocks.setupTabEditors();
            bus.addListener(this::registerLayerDefinitions);
            bus.addListener(this::registerRenderers);
        });
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AtmosphericConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        HashSet validBlocks = Sets.newHashSet((Iterable)BlockEntityType.f_271323_.f_58915_);
        validBlocks.addAll(Sets.newHashSet((Object[])new Block[]{(Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get(), (Block)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND.get()}));
        BlockEntityType.f_271323_.f_58915_ = ImmutableSet.copyOf((Collection)validBlocks);
        event.enqueueWork(() -> {
            AtmosphericVillagers.registerVillagerTypes();
            AtmosphericCompat.registerCompat();
            AtmosphericMobEffects.registerBrewingRecipes();
            AtmosphericDecoratedPotPatterns.registerDecoratedPotPatterns();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> AtmosphericClientCompat.registerCompat());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        AtmosphericDatapackBuiltinEntriesProvider datapackEntries = new AtmosphericDatapackBuiltinEntriesProvider(output, provider);
        generator.addProvider(server, (DataProvider)datapackEntries);
        provider = datapackEntries.getRegistryProvider();
        AtmosphericBlockTagsProvider blockTags = new AtmosphericBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new AtmosphericItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new AtmosphericEntityTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericBiomeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericBannerPatternTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericTrimMaterialTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericStructureTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericDamageTypeTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericPaintingVariantTagsProvider(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericLootTableProvider(output));
        generator.addProvider(server, (DataProvider)new AtmosphericRecipeProvider(output));
        generator.addProvider(server, (DataProvider)AtmosphericAdvancementProvider.create(output, provider, helper));
        generator.addProvider(server, (DataProvider)new AtmosphericAdvancementModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericLootModifierProvider(output, provider));
        generator.addProvider(server, (DataProvider)new AtmosphericChunkGeneratorModifierProvider(output, provider));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new AtmosphericBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new AtmosphericItemModelProvider(output, helper));
        generator.addProvider(client, (DataProvider)new AtmosphericSpriteSourceProvider(output, helper));
        generator.addProvider(client, (DataProvider)new GalleryItemModelProvider(MOD_ID, output, helper));
        generator.addProvider(client, (DataProvider)new GalleryAssetsRemolderProvider(MOD_ID, output, provider));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AtmosphericModelLayers.TETRA, TetraModel::createBodyLayer);
        event.registerLayerDefinition(AtmosphericModelLayers.COCHINEAL, () -> CochinealModel.createBodyLayer(CubeDeformation.f_171458_));
        event.registerLayerDefinition(AtmosphericModelLayers.COCHINEAL_SADDLE, () -> CochinealModel.createBodyLayer(new CubeDeformation(0.5f)));
        event.registerLayerDefinition(AtmosphericModelLayers.PASSION_FRUIT_SEED, PassionFruitSeedModel::createBodyLayer);
        event.registerLayerDefinition(AtmosphericModelLayers.DRAGON_FRUIT, DragonFruitModel::createBodyLayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.TETRA.get(), TetraRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.COCHINEAL.get(), CochinealRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.PASSION_FRUIT_SEED.get(), PassionFruitSeedRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.DRAGON_FRUIT.get(), DragonFruitRenderer::new);
        event.registerEntityRenderer((EntityType)AtmosphericEntityTypes.ORANGE_VAPOR_CLOUD.get(), NoopRenderer::new);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

