/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.common.block.OrangeBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class OrangesDecorator
extends TreeDecorator {
    public static final Codec<OrangesDecorator> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(instance -> Float.valueOf(instance.probability)), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(instance -> instance.blockProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("orange_probability").forGetter(instance -> Float.valueOf(instance.orangeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_probability").forGetter(instance -> Float.valueOf(instance.doubleProbability))).apply((Applicative)codec, OrangesDecorator::new));
    private final float probability;
    private final float orangeProbability;
    private final float doubleProbability;
    private final BlockStateProvider blockProvider;

    public OrangesDecorator(float probability, BlockStateProvider provider, float orangeProbability, float doubleProbability) {
        this.probability = probability;
        this.blockProvider = provider;
        this.orangeProbability = orangeProbability;
        this.doubleProbability = doubleProbability;
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (random.m_188501_() < this.probability) {
            for (BlockPos pos : context.m_226069_()) {
                ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.values()));
                directions.remove(Direction.UP);
                Collections.shuffle(directions);
                for (Direction direction : directions) {
                    BlockPos offsetPos = pos.m_121945_(direction);
                    if (!(random.m_188501_() < this.orangeProbability) || !context.m_226059_(offsetPos)) continue;
                    context.m_226061_(offsetPos, (BlockState)((BlockState)this.blockProvider.m_213972_(random, offsetPos).m_61124_((Property)OrangeBlock.f_52588_, (Comparable)direction)).m_61124_((Property)OrangeBlock.ORANGES, (Comparable)Integer.valueOf(random.m_188501_() < this.doubleProbability ? 2 : 1)));
                }
            }
        }
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)AtmosphericFeatures.ORANGES.get();
    }
}

