/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.levelgen.feature.MonkeyBrushFeature;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.atmospheric.core.registry.AtmosphericFeatures;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class MonkeyBrushDecorator
extends TreeDecorator {
    public static final Codec<MonkeyBrushDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(MonkeyBrushDecorator::new, decorator -> Float.valueOf(decorator.probability)).codec();
    private final float probability;

    public MonkeyBrushDecorator(float probability) {
        this.probability = probability;
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        if (random.m_188501_() < this.probability) {
            ArrayList<Block> brushes = new ArrayList<Block>();
            if (random.m_188503_(2) == 0) {
                brushes.add((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            }
            if (random.m_188503_(3) == 0) {
                brushes.add((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            }
            if (random.m_188503_(4) == 0) {
                brushes.add((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            }
            if (!brushes.isEmpty()) {
                for (BlockPos pos : context.m_226068_()) {
                    for (Direction direction : Direction.values()) {
                        BlockPos offsetPos = pos.m_121945_(direction);
                        if (random.m_188503_(3) != 0 || !context.m_226059_(offsetPos)) continue;
                        context.m_226061_(offsetPos, MonkeyBrushFeature.monkeyBrushState(((Block)brushes.get(random.m_188503_(brushes.size()))).m_49966_(), direction));
                    }
                }
            }
        }
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)AtmosphericFeatures.MONKEY_BRUSH.get();
    }
}

