/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.block.MonkeyBrushBlock;
import com.teamabnormals.atmospheric.common.block.WallMonkeyBrushBlock;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MonkeyBrushFeature
extends Feature<NoneFeatureConfiguration> {
    private final int temp;

    public MonkeyBrushFeature(Codec<NoneFeatureConfiguration> p_i49876_1_, int temperature) {
        super(p_i49876_1_);
        this.temp = temperature;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        BlockState blockstate = ((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get()).m_49966_();
        if (this.temp == 3) {
            blockstate = ((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()).m_49966_();
        } else if (this.temp == 1) {
            blockstate = ((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get()).m_49966_();
        }
        int i = 0;
        for (int j = 0; j < 64; ++j) {
            BlockPos blockpos = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!worldIn.m_46859_(blockpos) || blockpos.m_123342_() >= 255 || !blockstate.m_60710_((LevelReader)worldIn, blockpos)) continue;
            Direction randomD = Direction.m_235672_((RandomSource)rand);
            while (!MonkeyBrushFeature.monkeyBrushState(blockstate, randomD).m_60710_((LevelReader)worldIn, blockpos)) {
                randomD = Direction.m_235672_((RandomSource)rand);
            }
            worldIn.m_7731_(blockpos, MonkeyBrushFeature.monkeyBrushState(blockstate, randomD), 2);
            ++i;
        }
        return i > 0;
    }

    public static BlockState monkeyBrushState(BlockState state, Direction direction) {
        if (direction.m_122434_().m_122478_() && state.m_60734_() instanceof MonkeyBrushBlock) {
            return (BlockState)state.m_61124_((Property)MonkeyBrushBlock.FACING, (Comparable)direction);
        }
        if (state.m_60734_() == AtmosphericBlocks.WARM_MONKEY_BRUSH.get()) {
            state = ((Block)AtmosphericBlocks.WARM_WALL_MONKEY_BRUSH.get()).m_49966_();
        }
        if (state.m_60734_() == AtmosphericBlocks.HOT_MONKEY_BRUSH.get()) {
            state = ((Block)AtmosphericBlocks.HOT_WALL_MONKEY_BRUSH.get()).m_49966_();
        }
        if (state.m_60734_() == AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get()) {
            state = ((Block)AtmosphericBlocks.SCALDING_WALL_MONKEY_BRUSH.get()).m_49966_();
        }
        return (BlockState)state.m_61124_((Property)WallMonkeyBrushBlock.FACING, (Comparable)direction);
    }
}

