/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.common.entity.OrangeVaporCloud;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrangeBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty ORANGES = IntegerProperty.m_61631_((String)"oranges", (int)1, (int)2);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SINGLE = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)11.0);
    private static final VoxelShape SINGLE_CEILING = Block.m_49796_((double)5.0, (double)8.0, (double)4.0, (double)12.0, (double)14.0, (double)11.0);
    private static final VoxelShape SINGLE_WALL = Block.m_49796_((double)5.0, (double)4.0, (double)9.0, (double)12.0, (double)10.0, (double)16.0);
    private static final VoxelShape DOUBLE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape DOUBLE_CEILING = Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final VoxelShape DOUBLE_WALL = Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape DOUBLE_COLLISION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)8.0, (double)6.0, (double)8.0), (VoxelShape)Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)15.0, (double)6.0, (double)15.0));
    private static final VoxelShape DOUBLE_CEILING_COLLISION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)8.0, (double)14.0, (double)8.0), (VoxelShape)Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)15.0, (double)14.0, (double)15.0));
    private static final VoxelShape DOUBLE_WALL_COLLISION = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)9.0, (double)8.0, (double)6.0, (double)16.0), (VoxelShape)Block.m_49796_((double)9.0, (double)8.0, (double)9.0, (double)16.0, (double)14.0, (double)16.0));

    public OrangeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)ORANGES, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return OrangeBlock.canAttach(level, pos, ((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean single = (Integer)state.m_61143_((Property)ORANGES) < 2;
        return switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case Direction.UP -> {
                if (single) {
                    yield SINGLE;
                }
                yield DOUBLE;
            }
            case Direction.DOWN -> {
                if (single) {
                    yield SINGLE_CEILING;
                }
                yield DOUBLE_CEILING;
            }
            default -> OrangeBlock.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)f_52588_), single ? SINGLE_WALL : DOUBLE_WALL);
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if ((Integer)state.m_61143_((Property)ORANGES) < 2) {
            voxelShape = this.m_5940_(state, level, pos, context);
        } else {
            switch ((Direction)state.m_61143_((Property)f_52588_)) {
                case UP: {
                    voxelShape = DOUBLE_COLLISION;
                    break;
                }
                case DOWN: {
                    voxelShape = DOUBLE_CEILING_COLLISION;
                    break;
                }
                default: {
                    voxelShape = OrangeBlock.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)f_52588_), DOUBLE_WALL_COLLISION);
                }
            }
        }
        return voxelShape;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static boolean canAttach(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos relativePos = pos.m_121945_(direction);
        return level.m_8055_(relativePos).m_60783_((BlockGetter)level, relativePos, direction.m_122424_()) || level.m_8055_(relativePos).m_204336_(BlockTags.f_13035_);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState offsetState, LevelAccessor level, BlockPos pos, BlockPos offsetPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return ((Direction)state.m_61143_((Property)f_52588_)).m_122424_() == direction && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, offsetState, level, pos, offsetPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag;
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = flag = fluidState.m_76152_() == Fluids.f_76193_;
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61122_((Property)ORANGES);
        }
        for (Direction direction : context.m_6232_()) {
            BlockState newState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            if (!newState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return newState;
        }
        return null;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        if (!level.f_46443_) {
            if ((Integer)state.m_61143_((Property)ORANGES) < 2) {
                level.m_46961_(pos, false);
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)ORANGES, (Comparable)Integer.valueOf(1)));
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            }
            OrangeBlock.createVaporCloud(level, new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f)), state.m_60713_((Block)AtmosphericBlocks.BLOOD_ORANGE.get()));
        }
        super.m_142072_(level, state, pos, entity, distance);
    }

    public static void createVaporCloud(Level level, Vec3 pos, boolean blood) {
        OrangeVaporCloud cloud = new OrangeVaporCloud(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
        cloud.setBloodOrange(blood);
        cloud.setRadius(1.5f);
        cloud.setDuration(600);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        level.m_7967_((Entity)cloud);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)ORANGES) < 2 || super.m_6864_(state, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, ORANGES, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }
}

